      program read_snp_file
	  implicit none
	  character(len=10) :: inline
	  character(len=22),dimension(36) :: var_name
	  character(len=22),dimension(20) :: sed_var_name
	  real :: jday
	  real,dimension(36,30) :: variable
	  real,dimension(36,30) :: sed_variable
	  integer :: i, j, var_code, sed_var_code
	  
! a program to read snapshot file from 30-box model.  Set up for 
! current bay model variables.  water colun and sediments.  no
! sav or filter feeders.

      open(10,file='wqm_snp.opt',status='old')
	  open(11,file='read_snp_file.wqopt',status='unknown')
	  open(12,file='read_snp_file.sedopt',status='unknown')
	  
! write column headers
      write(11,5) (j,j=1,30)
	  write(12,6) (j,j=1,10)
 5    format('      jday',30('   box ',i3))
 6    format('      jday',10('   box ',i3))
	  
! read boilerplate at head of file
      do i=1,326
	    read(10,*) inline
!        write(*,*) i, inline		
	  end do
            	  
! query for desired variable code
      write(*,*) 'what variable?'
	  read(5,*) var_code
	  write(*,*) 'variable',var_code,'requested'
	  
! query for desired sed variable code
      write(*,*) 'what sediment variable?'
	  read(5,*) sed_var_code
	  write(*,*) 'sediment variable',sed_var_code,'requested'
	  
! read outputs until end of file
      do
! read boilerplate until julian day
        do i=1,9
		  read(10,*,end=999) inline 	  
		end do

		! read julian day
        read(10,1) jday
 1      format(/25x,f8.1)
        write(*,*) jday
		
! read boilerplate until variable title
        do i=1,3
		  read(10,*) inline 		  
		end do
		
! read temperature through algal group 3 (1-6)
		do i=1,6
		  read(10,2) var_name(i)
		  read(10,*) (variable(i,j),j=1,30)
		end do
 2    format(//a22)
 
! read labile doc (9) 
          i=9
		  read(10,2) var_name(i)
		  read(10,*) (variable(i,j),j=1,30)
 
! read labile poc through nitrate (11-14)
		do i=11,14
		  read(10,2) var_name(i)
		  read(10,*) (variable(i,j),j=1,30)
		end do
 
! read labile don (16) 
          i=16
		  read(10,2) var_name(i)
		  read(10,*) (variable(i,j),j=1,30)
		  
! read labile pon through labile dop (18-21)
		do i=18,21
		  read(10,2) var_name(i)
		  read(10,*) (variable(i,j),j=1,30)
		end do

! read labile pop through do (23-27)
		do i=23,27
		  read(10,2) var_name(i)
		  read(10,*) (variable(i,j),j=1,30)
		end do

! read g3poc through fine clay (30-36)
		do i=30,36
		  read(10,2) var_name(i)
		  read(10,*) (variable(i,j),j=1,30)
		end do
		
! now for sediment state variables
! read 20 sediment state variables
		do i=1,20
		  read(10,2) sed_var_name(i)
		  read(10,*) (sed_variable(i,j),j=1,10)
		end do
		
! reads completed for one day.  write selected variables
        write(11,3) jday, (variable(var_code,j),j=1,30)
		write(12,4) jday, (sed_variable(sed_var_code,j),j=1,10)
 3      format(f10.2,30f10.4)
 4      format(f10.2,10e10.3)
	  
	  end do
	  
 999  close(11)
      close(12)
	  
	  end
