      MODULE SIZES
C***** Parameter declarations
C***** CHESAPEAKE BAY 50,000 CELL MODEL  /mnt/cercolx1/1994_HYDRO

      INTEGER,PARAMETER :: NCP=36,
c    .                     NBP=56920,
c    .                     NQFP=147941,
c    .                     NHQP=102085,
c    .                     NSQFP=20439,
c    .                     NSBP=11064,

c for running 48 PEs
C    .                     NBP=2104,
C    .                     NQFP=4352,
C    .                     NHQP=2567,
C    .                     NSQFP=860,
C    .                     NSBP=543,

c for running 32 PEs
     .                     NBP=2958,
     .                     NQFP=6349,
     .                     NHQP=3772,
     .                     NSQFP=1226,
     .                     NSBP=777,

c for running 64 PEs
c    .                     NBP=1688,
c    .                     NQFP=3439,
c    .                     NHQP=1960,
c    .                     NSQFP=645,
c    .                     NSBP=419,

c for running 96 PEs
c    .                     NBP=1369,
c    .                     NQFP=2603,
c    .                     NHQP=1387,
c    .                     NSQFP=472,
c    .                     NSBP=315,

c for running 4 PEs
c    .                     NBP=15645,
c    .                     NQFP=39008,
c    .                     NHQP=26486,
c    .                     NSQFP=5586,
c    .                     NSBP=3123,

c for running 6 PEs
c    .                     NBP=11049,
c    .                     NQFP=27078,
c    .                     NHQP=18159,
c    .                     NSQFP=4030,
c    .                     NSBP=2353,

c for running 8 PEs
C    .                     NBP=8651,
C    .                     NQFP=21692,
C    .                     NHQP=14236,
C    .                     NSQFP=3227,
C    .                     NSBP=1977,

c for running 16 PEs
C    .                     NBP=4642,
C    .                     NQFP=11255,
C    .                     NHQP=7183,
C    .                     NSQFP=1918,
C    .                     NSBP=1173,


     .                     NLP=19,
     .                     NS1P=3000,
     .                     NS2P=3000,
     .                     NS3P=12000,
     .                     NBCP=243,
     .                     NMP=30,
     .                     NDP=500,
     .                     NFLP=100,
     .                     NOIP=10,
     .                     NSSFP=10,
     .                     NSAVP=5, 
     .                     LAYMAX=7, 
     .                     NCMAX=5, 
     .                     NSDCLS=4 
      END MODULE SIZES


      MODULE FILE_INFO
      USE SIZES
      INTEGER    HYD, DIA, CBC, S1,  S2,  S3,  
     .           BFI, MET, BFO, KEI,
     .           ATM, STL, AGR, SVI, SVO, KFL, ALO,
     .           CON, SNP, GEO, PLT, APL, TFL, OPL, SUS, SUD,
     .           MAP, ICI, ICO, MRL, SAVPF

      integer :: wtl_unit=22, wtl_write=49

      CHARACTER(20) :: SSNAME(18)
      CHARACTER(24) :: CNAME(NCP)
      CHARACTER(18) :: CONFN ='wqm_con.npt'
      CHARACTER(22) :: SEDCONFN ='wqm_sed_con.npt'

c--------------------end of data declarations---------------------------------c

      CONTAINS

      SUBROUTINE INIT_FILE_INFO()
C
      CON = 10 
      HYD = 20
      BFI = 21
       S1 = 23
       S2 = 24 
       S3 = 34
      ATM = 25 
      STL = 26 
      AGR = 27
      SVI = 28 
      MET = 29 
      KEI = 30 
      SVO = 31
      SAVPF = 38
      ALO = 50
      DIA = 40 
      BFO = 41 
      KFL = 47
      MAP = 32 
      GEO = 33  
      ICI = 35 
      ICO = 36
      MRL = 37 
      SUS = 58
      SUD = 59
      SNP = 43 
      PLT = 44 
      APL = 45 
      TFL = 46 
      OPL = 48
      CBC = 60 

      SSNAME(1)  = 'Sediment Temperature'
      SSNAME(2)  = 'Sediment POP        '
      SSNAME(3)  = 'Sediment PON        '  
      SSNAME(4)  = 'Sediment POC        ' 
      SSNAME(5)  = 'Sediment PBS        ' 
      SSNAME(6)  = 'Sediment PO4        '
      SSNAME(7)  = 'Sediment NH4        '
      SSNAME(8)  = 'Sediment NO3        '
      SSNAME(9)  = 'Sediment HS         '
      SSNAME(10) = 'Sediment CH4        '
      SSNAME(11) = 'Sediment CH4        '
      SSNAME(12) = 'Sediment SO4        '
      SSNAME(13) = 'Sediment DSIL       '
      SSNAME(14) = 'Benthic Stress      '
      SSNAME(15) = 'Benthic Algae       '
      SSNAME(17) = 'Suspension Feeders  '
      SSNAME(18) = 'Sediment PIP        '


      CNAME(1)  =  'Temperature'
      CNAME(2)  =  'Salinity'
      CNAME(3)  =  'Inorganic Solids'
      CNAME(4)  =  'Algal Group 1'
      CNAME(5)  =  'Algal Group 2' 
      CNAME(6)  =  'Algal Group 3'
      CNAME(7)  =  'Zooplankton Group 1'
      CNAME(8)  =  'Zooplankton Group 2'
      CNAME(9)  =  'Labile DOC'           
      CNAME(10) =  'Refractory DOC'      
      CNAME(11) =  'Labile POC'                 
      CNAME(12) =  'Refractory POC'      
      CNAME(13) =  'Ammonium'
      CNAME(14) =  'Nitrate-nitrite' 
      CNAME(15) =  'Urea'             
      CNAME(16) =  'Labile DON'                 
      CNAME(17) =  'Refractory DON'      
      CNAME(18) =  'Labile PON'                 
      CNAME(19) =  'Refractory PON'      
      CNAME(20) =  'Total phosphate'
      CNAME(21) =  'Labile DOP'                 
      CNAME(22) =  'Refractory DOP'      
      CNAME(23) =  'Labile POP'                 
      CNAME(24) =  'Refractory POP'      
      CNAME(25) =  'Particulate Inorganic P'
      CNAME(26) =  'COD'
      CNAME(27) =  'Dissolved oxygen'
      CNAME(28) =  'Particulate silica  '
      CNAME(29) =  'Dissolved silica'
      CNAME(30) =  'G3POC'
      CNAME(31) =  'G3PON'
      CNAME(32) =  'G3POP'
      CNAME(33) =  'Clay'
      CNAME(34) =  'Silt'
      CNAME(35) =  'Sand'
      CNAME(36) =  'Org Sed'

      RETURN
      END SUBROUTINE INIT_FILE_INFO

      END MODULE FILE_INFO


      MODULE WQM    
      USE SIZES
      IMPLICIT REAL(A-H,O-Z)
********************************************************************************
**                                                                            **
**                        COMMON file for CE-QUAL-IC                          **
**                                                                            **
**                                Version 1.1                                 **
**                               July 28, 1992                                **
**                                                                            **
**                        Water Quality Modeling Group                        **
**                        U.S. Army Corps of Engineers                        **
**                        Waterways Experiment Station                        **
**                        Vicksburg, Mississippi 39180                        **
**                                                                            **
********************************************************************************

********************************************************************************
**                                                                            **
**                           PARAMETER definitions                            **
**                                                                            **
**    NBP   - Number of boxes                                                 **
**    NQFP  - Number of horizontal and vertical flow faces                    **
**    NHQP  - Number of horizontal flow faces                                 **
**    NSBP  - Number of boxes in the surface layer                            **
**    NLP   - Maximum number of layers                                        **
**    NS1P  - Number of source one inputs                                     **
**    NS2P  - Number of source two inputs                                     **
**    NS3P  - Number of source three inputs                                   **
**    NBCP  - Number of boundary concentration inputs                         **
**    NMP   - Number of modifications to initial box concentrations           **
**    NDP   - Maximum number of days for any output                           **
**    NFLP  - Number of files for each type of time-varying data              **
**    NCP   - Number of constituent state variables                           **
**    NSSFP - Number of suspension-feeding species                            **
**                                                                            **
********************************************************************************


********************************************************************************
**                        Water Quality Model Setup                           **
********************************************************************************


***** Data type declarations

      INTEGER B,      SBN,    BB,     BU,     BBN,    VFN,    S1LB,
     .        S1LN,   S2LB,   S2LN,   S3LB,   S3LN,   SAVB,   AC,     BD
      INTEGER HYDPTR, METPTR, CBCPTR, S1PTR,  S2PTR,  S3PTR,  BFIPTR, 
     .        ATMPTR, SAVPTR
      REAL    KHR1,   KHR2,   KHR3,   KHN1,   KHN2,   KHN3,   KHP1,
     .        KHP2,   KHP3,   KHONT,  KHOCOD, KHNNT,  KHODOC,
     .        KHTIS,  S2L,    KHNDN,  KHS1,   KHS2,   KHS3,   KHST1,
     .        KHST2,  KHST3,  KHNH41, KHNH42, KHNH43
      REAL    KLDC,   KRDC,   KLPC,   KRPC,   KG3C,   KG3N,   KG3P,
     .        KCOD,   KLDN,   KRDN,   KLDP,   KRDP,   KDPALG,
     .        KLPN,   KLPP,   KDPIP,  KRPN,   KRPP,   NTM 
      REAL    KHPAVG, KRDO
      REAL    KSO,    KSNH4,  KSNO3,  KSPO4,  KSDOC,  KHSO,   MTCNO3
      REAL    KTNT1,  KTNT2,  KTCOD,  KTMNL,  KTHDR
      REAL    LPOC,   LPON,   LPOP,   MNLLDOC,MNLRDOC,MTVEL,  CODMNL
      REAL    NT,     KT,     NXCBC,  JDAY
      REAL    NXMET,  NXS1,   NXS2,   NXS3,   NXBFI,  NXATM,  NXSAV
      REAL    KE,     KESS,   KEISS,  KEVSS,  KECHL,  KESAL,  VSStoPOC
      REAL    I0,     IT,     ITNX,   ISMIN,  IATBOT, IAVG
      REAL    NH4,    NO3,    LDOC,   LDON,   LDOP,   NL1,    NL2,    
     $        NL3,    NPP,    NASRAT 
      REAL    KADPO4, JBSPO4, JESPO4, SPO4
      REAL    MNLLDON,MNLRDON,MNLLDOP,MNLRDOP,NITRIF

C  variables needed by autostep and main   VJP 10/11/04
      INTEGER,SAVE :: NXHYD = 0
      REAL(4),SAVE :: COURMX, COURQS, COURVS
      REAL(4),SAVE :: DIFFMX, DIFFAS, DIFFDS, FNDLT
      REAL(4),SAVE :: V1SINGLE(0:NBP)
      REAL(8),SAVE :: DLT8, MAXDLTDP, MXDLTDP, NXHYDDP, ELTMS1
      REAL(8)  V1,       V2,      ELTMS

      LOGICAL SOURCE_ONE,     SOURCE_TWO,
     .        SOURCE_THR,     SOLIDS_CALC,      PIP_CALC,
     .        BENTHIC_FLUXES, SEDIMENT_CALC,    LIGHT_EXTINCTION,
     .        ATMOS_LOADS,    H_TRANS_FLUX,     V_TRANS_FLUX,
     .        S_TRANS_FLUX,   
     .        AVERAGE_PLOTS,  QUALITY_DIAG,     KINETIC_FLUXES,
     .        SEDIMENT_DIAG,  DIAGNOSTICS,      CONSERVE_MASS,
     .        SETTLING,       STEP_BOUNDARY
      LOGICAL SAV_CALC,       SAV_PLOTS
      LOGICAL POSITIVE_FLOW,  FLOW,             XY_DIFFUSION,
     .        Z_DIFFUSION,    BINARY_HYDRO,     ASCII_HYDRO,
     .        DEPTH_AVG_HYDRO, SIGMA_HYDRO                              !JLM ST JOHNS
      CHARACTER*8  SPVARKE, PRINTKE
      CHARACTER*72 METFN,  S1FN,   S2FN,  HYDFN,  CBCFN,  KEIFN,
     .             ATMFN,  SVIFN,  SVOFN, BFIFN,  BFOFN,  
     .             ALOFN,  S3FN
      CHARACTER*8  MINPROD, EREAR
      CHARACTER*3  SEDKIN

      LOGICAL NEW_HYDRO_FILE        ! CFC 070105
      REAL DLTN                     ! CFC 070105

***** Dimension declarations

      DIMENSION POSITIVE_FLOW(NQFP)
      DIMENSION NVF(NSBP),        VFN(0:NLP,NSBP)
      DIMENSION BFLUX(NSBP,11),    BFLUXB(NSBP,7)

C vjp 10/04/04 moved declaration from module WQM_INIT
      DIMENSION DTM(0:NBP,NCP)
      DIMENSION C1(0:NBP,NCP),    C2(0:NBP,NCP),    CSTAR(0:NBP,NCP),
     .          DTC(0:NBP,NCP),   AC1(0:NBP,NCP),   CMASS(NCP)
      DIMENSION S1L(NS1P,NCP),    S2L(NS2P,NCP),    S3L(NS3P,NCP),
     .          S1LB(NS1P,NCP),   S2LB(NS2P,NCP),   S3LB(NS3P,NCP)

      DIMENSION CB(NBCP,NCP),     CBNX(NBCP,NCP),   CBOLD(NBCP,NCP)

      REAL*8    CPOP(NSBP,3),     CPON(NSBP,3),     CPOC(NSBP,3)  ! as per jf 10/07/16
      DIMENSION FLXPOP(NSBP,3),   FLXPON(NSBP,3),   FLXPOC(NSBP,3),
     .          CPO4(NSBP),       CNO3(NSBP),
     .          CNH4(NSBP),       FLXPOS(NSBP),     CTEMP(NSBP),
     .          CDTEMP(NSBP),     BSVOL(NSBP),      HSED(NSBP),
     .          CCH4(NSBP),       CSO4(NSBP),       CHS(NSBP),          !CFC
     .          CSI(NSBP),        CPIP(NSBP),       FLXPIP(NSBP)        !CFC
      DIMENSION FLUXT(0:NQFP,NCP),FLUXS(0:NQFP,NCP),AFLUXT(0:NQFP,NCP),
     .          AFLUXS(0:NQFP,NCP)
      DIMENSION FLXTTEM(NQFP),    FLXTSAL(NQFP),    FLXTSSI(NQFP),
     .          FLXT1(NQFP),      FLXT2(NQFP),      FLXT3(NQFP),
     .          FLXTLDOC(NQFP),   FLXTLPOC(NQFP),   FLXTRPOC(NQFP),
     .          FLXTNH4(NQFP),    FLXTNO3(NQFP),    FLXTLDON(NQFP),
     .          FLXTLPON(NQFP),   FLXTRPON(NQFP),   FLXTPO4(NQFP),
     .          FLXTLDOP(NQFP),   FLXTLPOP(NQFP),   FLXTRPOP(NQFP),
     .          FLXTCOD(NQFP),    FLXTDO(NQFP),     
     .          FLXTRDOC(NQFP),   FLXTRDON(NQFP),   FLXTRDOP(NQFP),
     .          FLXTUREA(NQFP),   FLXTPIP(NQFP),    FLXTG3POC(NQFP),
     .          FLXTG3PON(NQFP),  FLXTG3POP(NQFP)
      DIMENSION FLXSTEM(NQFP),    FLXSSAL(NQFP),    FLXSSSI(NQFP),
     .          FLXS1(NQFP),      FLXS2(NQFP),      FLXS3(NQFP),
     .          FLXSLDOC(NQFP),   FLXSLPOC(NQFP),   FLXSRPOC(NQFP),
     .          FLXSNH4(NQFP),    FLXSNO3(NQFP),    FLXSLDON(NQFP),
     .          FLXSLPON(NQFP),   FLXSRPON(NQFP),   FLXSPO4(NQFP),
     .          FLXSLDOP(NQFP),   FLXSLPOP(NQFP),   FLXSRPOP(NQFP),
     .          FLXSCOD(NQFP),    FLXSDO(NQFP),     
     .          FLXSRDOC(NQFP),   FLXSRDON(NQFP),   FLXSRDOP(NQFP),
     .          FLXSUREA(NQFP),   FLXSPIP(NQFP),    FLXSG3POC(NQFP),
     .          FLXSG3PON(NQFP),  FLXSG3POP(NQFP),  FLXSCLAY(NQFP),
     .          FLXSSILT(NQFP),   FLXSSAND(NQFP),   FLXSORGM(NQFP)
      DIMENSION ABENDOC(NSBP),    ABENNH4(NSBP),    ABENNO3(NSBP),
     .          ABENPO4(NSBP),    ABENCOD(NSBP),    ABENDO(NSBP),
     .          ASSFWS(NSBP),     APCFWS(NSBP),
     .          APNFWS(NSBP),     APPFWS(NSBP),    
     .          ACPOC(NSBP,3),    ACPON(NSBP,3),    ACPOP(NSBP,3),
     .          ACPO4(NSBP),      ACPIP(NSBP),      
     .          ASFEED(NSBP,NSSFP),
     .          ASFFILTCT(NSBP,NSSFP),              APIPFWS(NSBP),
     .          ABENCH4G(NSBP),   ABENCH4A(NSBP)
      DIMENSION AJNSF(NSBP),      AJPSF(NSBP),      ASODSF(NSBP)
     .         ,ASFGCIN(NSBP)
     .         ,ASFCFEC(NSBP),    ASFCPSF(NSBP),    AFLXCSF(NSBP)
     .         ,AFLXNSF(NSBP),    AFLXPSF(NSBP),    ARPOCSF(NSBP)
     .         ,ARPONSF(NSBP),    ARPOPSF(NSBP),    ASSISF(NSBP)
     .         ,ASSIPSF(NSBP),    ACHARV(NSBP,NSSFP)
     .         ,ASF_CFILT(NSBP),  ASF_NFILT(NSBP),  ASF_PFILT(NSBP)
     .         ,AG3CSF(NSBP),     AG3NSF(NSBP),     AG3PSF(NSBP)
      DIMENSION ACCHL1(NBP),  ACCHL2(NBP),  ACCHL3(NBP)
      DIMENSION S1LN(NCP),    S2LN(NCP),    S3LN(NCP),    AC(NCP)          
      DIMENSION Q(0:NQFP),    ILB(0:NQFP),  IB(0:NQFP),   JB(0:NQFP),
     .          JRB(0:NQFP),  A(0:NQFP),    DIFF(0:NQFP)
      DIMENSION BL(0:NBP,3),  V1S(0:NBP),   HMV(0:NBP),   HMBV(NSBP), 
     .          ZD(0:NBP),    BU(0:NBP),    BD(0:NBP)
      DIMENSION V1(0:NBP),    V2(0:NBP)
      DIMENSION PN1(NBP),     PN2(NBP),     PN3(NBP),     BM1(NBP),
     .          BM2(NBP),     BM3(NBP),     MNLLDOC(NBP), FTCOD(NBP),
     .          NPP(NBP),     P1(NBP),      P2(NBP),      P3(NBP),
     .          NT(NBP),      PR1(NBP),     PR2(NBP),     PR3(NBP),
     .          DENIT(NBP),   ASRAT(NSBP),  CFIX(NBP),    CODMNL(NBP),
     .          GPP(NBP),     MNLRDOC(NBP), NASRAT(NSBP)
      DIMENSION AFI1(NBP),    ANL1(NBP),    APL1(NBP),    AFI2(NBP),
     .          ANL2(NBP),    APL2(NBP),    AFI3(NBP),
     .          ANL3(NBP),    APL3(NBP),    ANPP(NBP),    ARESP(NBP),
     .          AKE(NBP),     AASRAT(NSBP),
     .          ACFIX(NBP),   AGPP(NBP),    AKRDO(NSBP)
      DIMENSION AFIB(NSBP),   ANLB(NSBP),   APLB(NSBP),   ANPPB(NSBP),
     .          ABBM(NSBP),   ABLITE(NSBP), ABMB(NSBP),   APB(NSBP),
     .          APRB(NSBP),   ABADOC(NSBP), ABAPOC(NSBP), ABANH4(NSBP),
     .          ABANO3(NSBP), ABAPON(NSBP), ABAPO4(NSBP), ABAPOP(NSBP),
     .          ABADO(NSBP)
      DIMENSION ALEAF(NSBP),      AEP(NSBP),
     .          AROOT(NSBP),      AFIEP(NSBP),
     .          ANPPSAV(NSBP),    ANPPEP(NSBP),
     .          ANLSAV(NSBP),     APLSAV(NSBP),
     .          AFNSED(NSBP),
     .          AFPSED(NSBP),     ANLEPI(NSBP),
     .          APLEPI(NSBP),     AWATATN(NSBP),
     .          AEPATN(NSBP),     ATUBER(NSBP),
     .          ASTEM(NSBP),      AFISH(NSBP),
     .          APLEAF(NSBP),     ASAVEFCT(NSBP)
      DIMENSION ABMLEAF(NSBP),    ASLSH(NSBP),
     .          ABMTUBER(NSBP),   APEP(NSBP),
     .          ABMEP(NSBP),      APREP(NSBP),
     .          ADOCSAV(NSBP)
      DIMENSION APOCSAV(NSBP),   ADOCEPI(NSBP),
     .          APOCEPI(NSBP),   ASEDCSAV(NSBP),
     .          ANH4SAVW(NSBP),  ANO3SAVW(NSBP),  ADONSAVW(NSBP),
     .          APONSAVW(NSBP),  ANH4EPI(NSBP),
     .          ANO3EPI(NSBP),   ADONEPI(NSBP),   APONEPI(NSBP),
     .          ASEDNSAV(NSBP),  ASEDNH4SAV(NSBP),
     .          APO4SAVW(NSBP),  ADOPSAVW(NSBP),  APOPSAVW(NSBP),
     .          APO4EPI(NSBP),   ADOPEPI(NSBP),
     .          APOPEPI(NSBP),   ASEDPSAV(NSBP),
     .          ASEDPO4SAV(NSBP),ADOSAV(NSBP),    ADOEPI(NSBP),
     .          ASEDDOSAV(NSBP)

      DIMENSION T(0:NBP),     SSI(0:NBP),   B1(0:NBP),    B2(0:NBP),
     .          B3(0:NBP),    LDOC(0:NBP),  LPOC(0:NBP),  RPOC(0:NBP),
     .          NH4(0:NBP),   NO3(0:NBP),   LDON(0:NBP),  LPON(0:NBP),
     .          RPON(0:NBP),  PO4(0:NBP),   LDOP(0:NBP),  LPOP(0:NBP),
     .          RPOP(0:NBP),  COD(0:NBP),   DO(0:NBP),    SALT(0:NBP),  
     .          RDOC(0:NBP),  RDON(0:NBP),  RDOP(0:NBP),  UREA(0:NBP),
     .          PIP(0:NBP),   G3POC(0:NBP), G3PON(0:NBP), G3POP(0:NBP)
      DIMENSION WSS(0:NBP),   WSL(0:NBP),   WSR(0:NBP),   WS1(0:NBP),
     .          WS2(0:NBP),   WS3(0:NBP),   WSG3(0:NBP),  WSPO4(0:NBP),
     .          WSPIP(0:NBP)
      DIMENSION PM1(NBP),     PM2(NBP),     PM3(NBP),     BMR1(NBP),
     .          BMR2(NBP),    BMR3(NBP),    BPR1(NBP),    BPR2(NBP),
     .          BPR3(NBP),    CCHL1(NBP),   CCHL2(NBP),   CCHL3(NBP)
      DIMENSION DTT(NBP),     DTSSI(NBP),   DTB1(NBP),    DTB2(NBP),
     .          DTB3(NBP),    DTLDOC(NBP),  DTLPOC(NBP),  DTRPOC(NBP),
     .          DTNH4(NBP),   DTNO3(NBP),   DTLDON(NBP),  DTLPON(NBP),
     .          DTRPON(NBP),  DTPO4(NBP),   DTLDOP(NBP),  DTLPOP(NBP),
     .          DTRPOP(NBP),  DTCOD(NBP),   DTDO(NBP),    DTRDOC(NBP),
     .          DTRDON(NBP),  DTRDOP(NBP),  DTUREA(NBP),  DTPIP(NBP),
     .          DTG3POC(NBP), DTG3PON(NBP), DTG3POP(NBP)
      DIMENSION KE(NBP),      FI1(NBP),     FI2(NBP),     FI3(NBP),
     .          NL1(NBP),     NL2(NBP),     NL3(NBP),     PL1(NBP),
     .          PL2(NBP),     PL3(NBP),     RESP(NBP),    KESS(NBP),    
     .          IAVG(NBP),    IATBOT(NBP),  KEISS(NBP),   KEVSS(NBP)
      DIMENSION FTMNL(NBP),   FTHDR(NBP)
      DIMENSION BENDOC(NSBP), BENNH4(NSBP), BENNO3(NSBP), BENDON(NSBP),
     .          BENDOP(NSBP), BENPO4(NSBP), BENCOD(NSBP), BENDO(NSBP),
     .          BENDEN(NSBP), BENCH4G(NSBP),BENCH4A(NSBP)
      DIMENSION BENDOCB(NSBP),BENNH4B(NSBP),BENNO3B(NSBP),BENPO4B(NSBP),
     .          BENCODB(NSBP),BENDOB(NSBP)
      DIMENSION SBN(NSBP),    BBN(NSBP),    HMSBV(NSBP),  SFA(NSBP)
      DIMENSION WSSNET(NSBP), WSLNET(NSBP), WSRNET(NSBP), WS1NET(NSBP),
     .          WS2NET(NSBP), WS3NET(NSBP), VSED(NSBP),   VPMIX(NSBP),
     .          VDMIX(NSBP),  DIAGP(NSBP),  DIAGN(NSBP),  DIAGC(NSBP),  !CFC
     .          DIAGS(NSBP),  MTVEL(NSBP),  WSG3NET(NSBP),
     .          WSPIPNET(NSBP)
      DIMENSION WSSBNET(NSBP), WSLBNET(NSBP), WSRBNET(NSBP), 
     .          WSG3BNET(NSBP),WSPIPBNET(NSBP),          
     .          WS1BNET(NSBP), WS2BNET(NSBP), WS3BNET(NSBP)
      DIMENSION PPFWS(NSBP),  PNFWS(NSBP),  PCFWS(NSBP),  
     .          SSFWS(NSBP),  PIPFWS(NSBP)
      DIMENSION METFN(NFLP),  S1FN(NFLP),   S2FN(NFLP),   S3FN(NFLP),
     .          HYDFN(NFLP), 
     .          CBCFN(NFLP),  ATMFN(NFLP),  SVIFN(NFLP), BFIFN(NFLP)
      DIMENSION FRPPH1(3),    FRPPH2(3),    FRPPH3(3), 
     .          FRNPH1(3),    FRNPH2(3),    FRNPH3(3),  
     .          FRCPH1(3),    FRCPH2(3),    FRCPH3(3), 
     .          FRCPHB(3),    FRNPHB(3),    FRPPHB(3),  PIE2PO4(NSBP),
     .          DPIE1PO4(NSBP) 
      DIMENSION HQCFA(NSQFP)
      DIMENSION KLDC(NBP),    KRDC(NBP),     KLPC(NBP),   KRPC(NBP),    
     .          KCOD(NBP),    KLDN(NBP),     KRDN(NBP),   KLDP(NBP),
     .          KRDP(NBP),    KDPALG(NBP),   KLPN(NBP),   KRDO(NSBP),  
     .          KLPP(NBP),    KDPIP(NBP),    KRPN(NBP),   KRPP(NBP),
     .          NTM(NBP),     KG3C(NBP),     KG3N(NBP),   KG3P(NBP)
      DIMENSION ALGDOC(NBP),  ALGPOC(NBP),   HDRLPOC(NBP), HDRRPOC(NBP),
     .          HDRG3POC(NBP)
      DIMENSION ALGNH4(NBP),  ALGNO3(NBP),   ALGDON(NBP),  ALGPON(NBP),
     .          DENNO3(NBP),  MNLLDON(NBP),  HDRLPON(NBP), HDRRPON(NBP),
     .          MNLRDON(NBP), HDRG3PON(NBP)
      DIMENSION ALGPO4(NBP),  ALGDOP(NBP),   ALGPOP(NBP),  MNLLDOP(NBP),
     .          HDRLPOP(NBP), HDRRPOP(NBP),  MNLRDOP(NBP), 
     .          HDRG3POP(NBP)
      DIMENSION DORALG(NBP),  DOPR(NBP),
     .          DCOD(NBP),    DDOC(NBP),     NITRIF(NBP)
      DIMENSION A_T(NBP),     AP1(NBP),      ABM1(NBP),    APR1(NBP),
     .          AP2(NBP),     ABM2(NBP),     APR2(NBP),    AP3(NBP),
     .          ABM3(NBP),    APR3(NBP)
      DIMENSION AALGDOC(NBP), AALGPOC(NBP),  ADENIT(NBP),  AMNLDOC(NBP),
     .          AHDRPOC(NBP)
      DIMENSION AALGNH4(NBP), AALGNO3(NBP),  AALGDON(NBP), AALGPON(NBP),
     .          ANT(NBP),     ADENNO3(NBP),  AMNLDON(NBP), AHDRPON(NBP)
      DIMENSION AALGPO4(NBP), AALGDOP(NBP),  AALGPOP(NBP), AMNLDOP(NBP),
     .          AHDRPOP(NBP)
      DIMENSION ADO(NBP),     ADORALG(NBP),  ADOPR(NBP),   ADCOD(NBP),
     .          ADDOC(NBP),   ANITRIF(NBP)
      DIMENSION FT1(-50:400),   FT2(-50:400),   FT3(-50:400),
     .          FTBM1(-50:400), FTBM2(-50:400), FTBM3(-50:400),
     .          FTPR(-50:400)
      DIMENSION B2GR(366)
      DIMENSION QLIT(NBP),    CONLIT(NBP,NCP) 
c sigma grid and evaporation
      DIMENSION HMCV(NSBP),   DLZF(NLP)
      DIMENSION RNMEVP(0:NSBP)                                            ! JLM FOR LOWER ST. JOHNS
     
Cvic 
cvjp  added these declarations to split main into init and timestep loop
Cvic 

      INTEGER   NSB
      integer,save ::  length, ijday
      integer,save ::  napl, ndlt, nsnp, nplt, ntfl
      integer,save ::  nkfl, nopl, noint
      integer,save ::  kfldp, inflow
      integer,save ::  ndia, nhydf, ntvdf, keiptr, numbox
      integer,save ::  jcb, it1, it2, it3, jt1, ivtmp, jvtmp
      integer,save ::  jcs1max, jcs2max, jcs3max, jdayvb

      real,save ::  th, cdiff, tmstrt, xydf, ctempi
      real,save ::  bensti, bbmi, ch4t2i, ch41ti, dummy
      real,save ::  eltmsplt, eltmstfl, eltmskfl, epi, hst2i, po4t2i
      real,save ::  rti, sfatot, shi, so4t2i, sum, cpipi 
      real,save ::  ratio, reltms, tods, dssr, savent, sedent, sfent
      real,save ::  sfatmp, alfas, conc1, conc2, conc3, cadv, omth 
      real,save ::  bndn, bndp, bndc 
      real,save ::  dos, dltav, eltmjd, hourvb, hmtv2
      real,save ::  wqmdlv, wqmtv2
      real,save ::  avgint, dtmp2

***** Equivalence declarations

c      EQUIVALENCE (C1(0,1),    CSTAR(0,1))
      EQUIVALENCE (T(0),       C2(0,1)),     (SALT(0),     C2(0,2)),
     .            (SSI(0),     C2(0,3)),     (B1(0),       C2(0,4)),
     .            (B2(0),      C2(0,5)),     (B3(0),       C2(0,6)),
     .            (LDOC(0),    C2(0,9)),     (RDOC(0),     C2(0,10)),    
     .            (LPOC(0),    C2(0,11)),    (RPOC(0),     C2(0,12)),
     .            (NH4(0),     C2(0,13)),    (NO3(0),      C2(0,14)), 
     .            (UREA(0),    C2(0,15)),    (LDON(0),     C2(0,16)),
     .            (RDON(0),    C2(0,17)),    (LPON(0),     C2(0,18)),
     .            (RPON(0),    C2(0,19)),    (PO4(0),      C2(0,20)),
     .            (LDOP(0),    C2(0,21)),    (RDOP(0),     C2(0,22)),
     .            (LPOP(0),    C2(0,23)),    (RPOP(0),     C2(0,24)),
     .            (PIP(0),     C2(0,25)),    (COD(0),      C2(0,26)),
     .            (DO(0),      C2(0,27)),    (G3POC(0),    C2(0,30)), 
     .            (G3PON(0),   C2(0,31)),    (G3POP(0),    C2(0,32))
      EQUIVALENCE (DTT(1),     DTC(1,1)),    
     .            (DTSSI(1),   DTC(1,3)),    (DTB1(1),     DTC(1,4)),    
     .            (DTB2(1),    DTC(1,5)),    (DTB3(1),     DTC(1,6)),    
     .            (DTLDOC(1),  DTC(1,9)),    (DTRDOC(1),   DTC(1,10)),
     .            (DTLPOC(1),  DTC(1,11)),   (DTRPOC(1),   DTC(1,12)),
     .            (DTNH4(1),   DTC(1,13)),   (DTNO3(1),    DTC(1,14)),
     .            (DTUREA(1),  DTC(1,15)),   (DTLDON(1),   DTC(1,16)),
     .            (DTRDON(1),  DTC(1,17)),   (DTLPON(1),   DTC(1,18)),
     .            (DTRPON(1),  DTC(1,19)),   (DTPO4(1),    DTC(1,20)),
     .            (DTLDOP(1),  DTC(1,21)),   (DTRDOP(1),   DTC(1,22)),
     .            (DTLPOP(1),  DTC(1,23)),   (DTRPOP(1),   DTC(1,24)),
     .            (DTPIP(1),   DTC(1,25)),   (DTCOD(1),    DTC(1,26)),
     .            (DTDO(1),    DTC(1,27)),   (DTG3POC(1),  DTC(1,30)), 
     .            (DTG3PON(1), DTC(1,31)),   (DTG3POP(1),  DTC(1,32))

C vjp 10/04/2004 moved this line from module WQM_INIT
      EQUIVALENCE (DTC(0,1), DTM(0,1))

      EQUIVALENCE (FLXTTEM(1), FLUXT(1,1)),  (FLXTSAL(1),  FLUXT(1,2)),
     .            (FLXTSSI(1), FLUXT(1,3)),  (FLXT1(1),    FLUXT(1,4)),
     .            (FLXT2(1),   FLUXT(1,5)),  (FLXT3(1),    FLUXT(1,6)),
     .            (FLXTLDOC(1),FLUXT(1,9)),  (FLXTRDOC(1), FLUXT(1,10)),
     .            (FLXTLPOC(1),FLUXT(1,11)), (FLXTRPOC(1), FLUXT(1,12)),
     .            (FLXTNH4(1), FLUXT(1,13)), (FLXTNO3(1),  FLUXT(1,14)),
     .            (FLXTUREA(1),FLUXT(1,15)), (FLXTLDON(1), FLUXT(1,16)),
     .            (FLXTRDON(1),FLUXT(1,17)), (FLXTLPON(1), FLUXT(1,18)), 
     .            (FLXTRPON(1),FLUXT(1,19)), (FLXTPO4(1),  FLUXT(1,20)),
     .            (FLXTLDOP(1),FLUXT(1,21)), (FLXTRDOP(1), FLUXT(1,22)),
     .            (FLXTLPOP(1),FLUXT(1,23)), (FLXTRPOP(1), FLUXT(1,24)),
     .            (FLXTPIP(1), FLUXT(1,25)), (FLXTCOD(1),  FLUXT(1,26)),
     .            (FLXTDO(1),  FLUXT(1,27)), (FLXTG3POC(1),FLUXT(1,30)), 
     .            (FLXTG3PON(1),FLUXT(1,31)),(FLXTG3POP(1),FLUXT(1,32))
      EQUIVALENCE (FLXSTEM(1), FLUXS(1,1)),  (FLXSSAL(1),  FLUXS(1,2)),
     .            (FLXSSSI(1), FLUXS(1,3)),  (FLXS1(1),    FLUXS(1,4)),
     .            (FLXS2(1),   FLUXS(1,5)),  (FLXS3(1),    FLUXS(1,6)),
     .            (FLXSLDOC(1),FLUXS(1,9)),  (FLXSRDOC(1), FLUXS(1,10)),
     .            (FLXSLPOC(1),FLUXS(1,11)), (FLXSRPOC(1), FLUXS(1,12)),
     .            (FLXSNH4(1), FLUXS(1,13)), (FLXSNO3(1),  FLUXS(1,14)),
     .            (FLXSUREA(1),FLUXS(1,15)), (FLXSLDON(1), FLUXS(1,16)),
     .            (FLXSRDON(1),FLUXS(1,17)), (FLXSLPON(1), FLUXS(1,18)), 
     .            (FLXSRPON(1),FLUXS(1,19)), (FLXSPO4(1),  FLUXS(1,20)),
     .            (FLXSLDOP(1),FLUXS(1,21)), (FLXSRDOP(1), FLUXS(1,22)),
     .            (FLXSLPOP(1),FLUXS(1,23)), (FLXSRPOP(1), FLUXS(1,24)),
     .            (FLXSPIP(1), FLUXS(1,25)), (FLXSCOD(1),  FLUXS(1,26)),
     .            (FLXSDO(1),  FLUXS(1,27)), (FLXSG3POC(1),FLUXS(1,30)), 
     .            (FLXSG3PON(1),FLUXS(1,31)),(FLXSG3POP(1),FLUXS(1,32)),
     .            (FLXSCLAY(1),FLUXS(1,33)), (FLXSSILT(1), FLUXS(1,34)),
     .            (FLXSSAND(1),FLUXS(1,35)), (FLXSORGM(1), FLUXS(1,36))       
      EQUIVALENCE (BENDOC(1),  BFLUX(1,1)),  (BENNH4(1),   BFLUX(1,2)),
     .            (BENNO3(1),  BFLUX(1,3)),  (BENDON(1),   BFLUX(1,4)),
     .            (BENPO4(1),  BFLUX(1,5)),  (BENDOP(1),   BFLUX(1,6)),
     .            (BENCOD(1),  BFLUX(1,7)),  (BENDO(1),    BFLUX(1,8)),
     .            (BENCH4A(1), BFLUX(1,10)), (BENCH4G(1),  BFLUX(1,11))
      EQUIVALENCE (BENDOCB(1), BFLUXB(1,1)), (BENNH4B(1),  BFLUXB(1,2)),
     .            (BENNO3B(1), BFLUXB(1,3)), (BENPO4B(1),  BFLUXB(1,4)),
     .            (BENCODB(1), BFLUXB(1,5)), (BENDOB(1),   BFLUXB(1,6))

***** Common declarations

      COMMON /TVDLGC/ SOURCE_ONE,     SOURCE_TWO,
     .                SOURCE_THR,
     .                BENTHIC_FLUXES, SEDIMENT_CALC,  LIGHT_EXTINCTION,
     .                ATMOS_LOADS,    SAV_CALC,       STEP_BOUNDARY
      COMMON /HYDLGC/ POSITIVE_FLOW,  FLOW,           XY_DIFFUSION,
     .                Z_DIFFUSION,    DIAGNOSTICS,    BINARY_HYDRO,
     .                CONSERVE_MASS,  ASCII_HYDRO,
     .                DEPTH_AVG_HYDRO, SIGMA_HYDRO                       ! JLM FOR LOWER ST. JOHNS (SIGMA_HYDRO)
      COMMON /AVGLGC/ AVERAGE_PLOTS,  QUALITY_DIAG,   SEDIMENT_DIAG,
     .                SAV_PLOTS
      COMMON /SEDLGC/ SETTLING,       SOLIDS_CALC,    PIP_CALC
      COMMON /HYDROC/ Q,      A,      DIFF,   HMBV,   HMSBV,  HMV,
     .                HQCFA,  SFA,    ILB,    IB,     JB,     JRB,
     .                VFN,    NVF,    DLT,    AHMDLT, NHMDLT, NWQMR,
     .                NHMR,   ZDFMUL, FILGTH, JDAY,   NIT,    RNMEVP        ! JLM FOR LOWER ST. JOHNS (RNMEVP)
      COMMON /TVDSC/  S1L,    S1LB,   S1LN,   S2L,    S2LB,   S2LN,
     .                S3L,    S3LB,   S3LN,   CB,     NCB,    NXCBC,  
     .                CBNX,   TMEND,
     .                CBOLD,  NXMET,  NXS1,   NXS2,   NXS3,   NXBFI,  
     .                NXATM,  NXSAV,  SPVARKE,PRINTKE,OLDNXCBC
      COMMON /AVGC1/  AC,     NAC,    AC1,    ACCHL1, ACCHL2, ACCHL3
      COMMON /AVGC2/  ABENDOC,ABENNH4,ABENNO3,ABENPO4,ABENCOD,ABENDO,
     .                ASSFWS, APCFWS, APNFWS, APPFWS, 
     .                ACPOC,  ACPON,  ACPOP,  ACPO4,  ACPIP,  
     .                asfeed, ABENCH4G, ABENCH4A,     AJNSF,  
     .                AJPSF,  ASODSF, ACHARV, ASFFILTCT,
     .                ASFGCIN,ASFCFEC,ASFCPSF,AFLXCSF,AFLXNSF,
     .                AFLXPSF,ARPOCSF,ARPONSF,ARPOPSF,ASSISF,
     .                ASSIPSF,ASF_CFILT,ASF_NFILT,ASF_PFILT,
     .                APIPFWS,AG3CSF, AG3NSF, AG3PSF
      COMMON /AVGC3/  AFI1,   ANL1,   APL1,   AFI2,   ANL2,   APL2,
     .                AFI3,   ANL3,   APL3,   ANPP,   ARESP,
     .                AKE,    AASRAT,ACFIX,  AGPP
      COMMON /AVGC4/  A_T,    AP1,    ABM1,   APR1,   AP2,    ABM2,
     .                APR2,   AP3,    ABM3,   APR3,   AALGDOC,AALGPOC,
     .                ADENIT, AMNLDOC,AHDRPOC,
     .                AALGNH4,AALGNO3,AALGDON,AALGPON,ANT,    ADENNO3,
     .                AMNLDON,AHDRPON,AALGPO4,
     .                AALGDOP,AALGPOP,AMNLDOP,AHDRPOP,ADO,    ADORALG, 
     .                ADOPR,  ADCOD,  ADDOC,  ANITRIF,AKRDO
      COMMON /AVGC5/  ALEAF,  AEP,    AROOT,  AFISH,  AFIEP,  ANPPSAV,
     .                ANPPEP, ANLSAV, APLSAV, AFNSED, AFPSED,
     .                ANLEPI, APLEPI, AWATATN,AEPATN, ASTEM,  ATUBER,
     .                ASAVEFCT
      COMMON /AVGC6/  ABBM,   ABLITE, ABMB,   APB,    APRB,   ABADOC,
     .                ABAPOC, ABANH4, ABANO3, ABAPON, ABAPO4, ABAPOP,
     .                ABADO,  AFIB,   ANLB,   APLB,   ANPPB
      COMMON /AVGC7/  APLEAF, ABMLEAF,ABMTUBER,ASLSH, APEP,   ABMEP,
     .                APREP,  ADOCSAV,APOCSAV, ADOCEPI,
     .                APOCEPI,ASEDCSAV, ANH4SAVW, ANO3SAVW,
     .                ADONSAVW, APONSAVW, ANH4EPI, ANO3EPI,
     .                ADONEPI, APONEPI,   ASEDNSAV, ASEDNH4SAV,
     .                APO4SAVW, ADOPSAVW, APOPSAVW, APO4EPI,
     .                ADOPEPI, APOPEPI,   ASEDPSAV, ASEDPO4SAV,
     .                ADOSAV, ADOEPI, ASEDDOSAV
      COMMON /GEOMC/  BL,     BU,     SBN,    BBN,    ZD,     NB,  
     .                NQF,    NL,     NSB,    NBB,    NHQF,   NSQF,  BD
      COMMON /DBLPR/  V1,     V2,     ELTMS
      COMMON /TEMPC/  KT,     TE,     WMS
      COMMON /SOLIDC/ KADPO4, KADSA,  JBSPO4, JESPO4, SPO4
      COMMON /OXYGNC/ AOCR,   AONT,   FTCOD,  FDOP,   AREAR,  BREAR,
     .                CREAR,  DREAR,  EREAR,  KRDO
      COMMON /CODMDC/ KCOD,   TRCOD,  KTCOD
      COMMON /NITROC/ TMNT,   NTM,    KTNT1,  KTNT2,  KHONT,  KHNNT,
     .                ANC1,   ANC2,   ANC3,   FNI1,   FNI2,   FNI3,
     .                FNLD1,  FNLD2,  FNLD3,  FNRD1,  FNRD2,  FNRD3,
     .                FNLP1,  FNLP2,  FNLP3,  FNRP1,  FNRP2,  FNRP3,
     .                FNIP,   FNLDP,  FNRDP,  FNLPP,  FNRPP,  
     .                FNG31,  FNG32,  FNG33,  FNG3P,
     .                KLDN,   KRDN,   KLPN,   KRPN,   KG3N,
     .                NT,     KHNDN,  DENIT,  ANDC
      COMMON /PHOSPC/ APC1,   APC2,   APC3,   FPI1,   FPI2,   FPI3,   
     .                FPLD1,  FPLD2,  FPLD3,  FPRD1,  FPRD2,  FPRD3,
     .                FPLP1,  FPLP2,  FPLP3,  FPRP1,  FPRP2,  FPRP3,
     .                FPIP,   FPLDP,  FPRDP,  FPLPP,  FPRPP, 
     .                FPG31,  FPG32,  FPG33,  FPG3P,
     .                KLDP,   KRDP,   KDPALG, KLPP,   KDPIP,  KG3P,
     .                KRPP,   KHPAVG
      COMMON /CARBC/  FCLD1,  FCLD2,  FCLD3,  FCRD1,  FCRD2,  FCRD3,
     .                FCLP1,  FCLP2,  FCLP3,  FCRP1,  FCRP2,  FCRP3,
     .                FCLDP,  FCRDP,  FCLPP,  FCRPP,
     .                FCG31,  FCG32,  FCG33,  FCG3P,
     .                KTMNL,  KTHDR,  TRMNL,  TRHDR,  FTMNL,  FTHDR,
     .                KLDC,   KRDC,   KLPC,   KRPC,   KG3C,
     .                MNLLDOC,MNLRDOC,CODMNL
      COMMON /ALGAE1/ KHP1,   KHP2,   KHP3,   CCHL1,  CCHL2,  CCHL3, 
     .                BMR1,   BMR2,   BMR3,   PM1,    PM2,
     .                PM3,    FR,     SCTOX,  KHS1,   KHS2,   KHS3,
     .                PR1,    PR2,    PR3,    BPR1,   BPR2,   BPR3,
     .                PRSP1,  PRSP2,  PRSP3,  STF1,   STF2,   STF3,
     .                KHST1,  KHST2,  KHST3,  FTPR,   B2GR,
     .                VMAX1,  VMAX2,  VMAX3,  PRPWR1, PRPWR2, PRPWR3
      COMMON /ALGAE2/ ALPH1,  ALPH2,  ALPH3,  CCHLC1, CCHLC2, CCHLC3
      COMMON /ALGAE3/ MINPROD
      COMMON /ALGTMP/ FT1,    FT2,    FT3,    FTBM1,  FTBM2,  FTBM3           
      COMMON /SED1C2/ CPON
      COMMON /SED1C/  CPOP,   FLXPOP, FLXPON, CPOC,   FLXPOC,
     .                CPO4,   CNO3,   CNH4,   FLXPOS, CTEMP,
     .                CDTEMP, BSVOL,  HSED,   VSED,   VPMIX,  CPIP,
     .                VDMIX,  DIAGP,  DIAGN,  DIAGC,  DIAGS,  CCH4,       !CFC
     .                CSO4,   CHS,    CSI,    FLXPIP                      !CFC 
      COMMON /SED2C/  FRPPH1, FRPPH2, FRPPH3, FRNPH1, FRNPH2,
     .                FRNPH3, FRCPH1, FRCPH2, FRCPH3, 
     .                FRCPHB, FRNPHB, FRPPHB, DCH4T2, DHST2
      COMMON /SED3C/  WSSNET,  WS1NET,  WS2NET,  WS3NET,  WSLNET,  
     .                WSRNET,  WSG3NET, WSSBNET, WS1BNET, WS2BNET, 
     .                WS3BNET, WSLBNET, WSRBNET, WSG3BNET,WSPIPNET,
     .                WSPIPBNET

      COMMON /CONSTC/ C1,     C2,     DTC
      COMMON /FLUXC/  FLUXT,  FLUXS,  AFLUXT,  AFLUXS, H_TRANS_FLUX,
     .                V_TRANS_FLUX,   S_TRANS_FLUX
      COMMON /PRODC/  P1,     P2,     P3
      COMMON /RESPRC/ BM1,    BM2,    BM3
      COMMON /NPREFC/ PN1,    PN2,    PN3
      COMMON /SETTLC/ WSS,    WS1,    WS2,    WS3,    WSL,    WSR,
     .                WSG3,   WSPO4,  WSPIP
      COMMON /HALFSC/ KHN1,   KHN2,   KHN3,   KHR1,   KHR2,   KHR3,
     .                KHOCOD, KHODOC, KHNH41, KHNH42, KHNH43
      COMMON /LIGHTC/ FD,     KE,     IT,     ITNX,   IATBOT,
     .                KHTIS,  I0,     TTSS,   KEISS,  KEVSS,  KECHL,  
     .                IAVG, KESS,     KESAL,  VSStoPOC
      COMMON /ATMC/   PRECIP, ATMNH4, ATMNO3, ATMLDON,ATMRDON,ATMPO4, 
     .                ATMLDOP,ATMRDOP
      COMMON /BENTHC/ KSO,    KSNH4,  KSNO3,  KSPO4,  KSSA,   KSDOC,
     .                TRSO,   TRSNH4, TRSNO3, TRSPO4, TRSSA,  TRSDOC,
     .                KHSO,   SEDNO3, MTCNO3, BFLUX,  BFLUXB, BENDEN, 
     .                MTVEL
      COMMON /DIAPLC/ FI1,    FI2,    FI3,    NL1,    NL2,    NL3,
     .                PL1,    PL2,    PL3,    RESP,   NPP,    
     .                ASRAT,  CFIX,   GPP,    NASRAT
      COMMON /BENPLC/ PPFWS,  PNFWS,  PCFWS,  SSFWS,  PIPFWS
      COMMON /FILENC/ METFN,  S1FN,   S2FN,   S3FN,   HYDFN,  CBCFN,    
     .                KEIFN,  
     .                ATMFN,  SVIFN,  SVOFN,  BFIFN,  BFOFN,  ALOFN
      COMMON /POINTC/ HYDPTR, METPTR, CBCPTR, S1PTR,  S2PTR,  S3PTR,
     .                BFIPTR, ATMPTR, SAVPTR
      COMMON /REDUCC/ REDS1C, REDS1N, REDS1P, REDS2C, REDS2N, REDS2P,
     .                REDCBC, REDCBN, REDCBP, REDS3C, REDS3N, REDS3P
      COMMON /KINFLX/ KINETIC_FLUXES
      COMMON /KINCAR/ ALGDOC, ALGPOC, HDRLPOC, HDRRPOC, HDRG3POC 
      COMMON /KINNIT/ ALGNH4, ALGNO3, ALGDON,  ALGPON,
     .                DENNO3, MNLLDON,MNLRDON, HDRLPON, HDRRPON,
     .                HDRG3PON
      COMMON /KINPHO/ ALGPO4, ALGDOP, ALGPOP,  MNLLDOP, MNLRDOP,
     .                HDRLPOP, HDRRPOP, HDRG3POP
      COMMON /KINOXY/ DORALG, DOPR,   DCOD,    DDOC,   NITRIF
      COMMON /LITTOR/ QLIT,   CONLIT
c sigma
      COMMON /SIGHYD/ HMCV,   DLZF

      COMMON /GLOBAL/ NEW_HYDRO_FILE, DLTN     ! CFC 070105


c  FOR (ROMS) SEDIMENT TRANSPORT
      LOGICAL SEDTR_CALC
      CHARACTER(72) USTFN(NFLP), BEDFN, SHRFN(NFLP)
      REAL USTARC(NSBP)
      REAL WSTLCLY(0:NBP), WSTLSLT(0:NBP)
      REAL WSTLSND(0:NBP), WSTLORG(0:NBP)
      REAL WSTBCLY(0:NSBP), WSTBSLT(0:NSBP), WSTBORG(0:NSBP)
      REAL SEDCLY(0:NBP),SEDSLT(0:NBP)
      REAL SEDSND(0:NBP),SEDORG(0:NBP)
      REAL D50(NSDCLS)
      REAL DTSCLY(NBP),DTSSLT(NBP)
      REAL DTSSND(NBP),DTSORG(NBP)
      REAL DTESCLY(NBP),DTESSLT(NBP)
      REAL DTESSND(NBP),DTESORG(NBP)
      REAL DTESSI(NBP)
      EQUIVALENCE (SEDCLY(0),  C2(0,33)),    (SEDSLT(0),   C2(0,34)),
     .            (SEDSND(0),  C2(0,35)),    (SEDORG(0),   C2(0,36))
      EQUIVALENCE (DTSCLY(1),  DTC(1,33)),    (DTSSLT(1),   DTC(1,34)),
     .            (DTSSND(1),  DTC(1,35)),    (DTSORG(1),   DTC(1,36))
      COMMON /FILESC/ USTFN, BEDFN, SHRFN
      COMMON /SEDTRZ/ USTARC
      COMMON /SEDTR1/ SEDTR_CALC
      COMMON /SEDTR2/ D50
      COMMON /SEDTR3/ DTESCLY,DTESSLT,DTESSND,DTESORG,DTESSI
      COMMON /SEDSTL/ WSTLCLY,WSTLSLT,WSTL1C,WSTL2C,WSTLSND,WSTLORG,
     .                WSTBCLY,WSTBSLT,WSTBORG

********************************************************************************
**                           Sediment Model Setup                             **
********************************************************************************


***** Variable declarations

      REAL    M1,       M2,        KAPPNH4F, KMNH4,    KMNH4O2,
     .        KAPPNO3F, K2NO3,     KAPPD1,   KAPPP1,   KMHSO2,
     .        KMO2DP,   KBENSTR,   k1no3,    kpie2,    kdpie1,
     .        KAPPCH4,  KPDIAG,    KNDIAG,   KCDIAG,   KAPPNH4S,
     .        KAPPNO3S, KLBNTH,   DPMIN
      REAL    K0H1D,    K0H1P,     K1H1D,    K1H1P,    K2H2D,
     .        K2H2P,    K3,        J1,       J2,       KMC1,
     .        KL12,     KL12NOM,   ISWBENS,  KHS_1,    KL12SO4
      REAL    NH41TM1S, NH4T2TM1S, NO31TM1S, NO3T2TM1S
      REAL    CH4T2TM1S, SO4T2TM1S,CH41TM1S                           !CH4
      REAL    NH40,     NH41,      NH42,     NH4T1,     NH4T2,
     .        NH41TM1,  NH4T2TM1,  JNH4,     NO30,      NO31,
     .        NO32,     NO3T1,     NO3T2,    NO31TM1,   NO3T2TM1,
     .        JNO3,     JHS,       JPO4,     JCH4AQ,
     .        JO2NH4,   KMCH4O2,   KMSO4,    PIPTM1,
     .        JCH4G,    CH40,      CH41,     CH42,
     .        CH42AV,   CH4T1,     CH4T2,    CH4T2AV,  CH41TM1,
     .        CH4T2TM1, JCH4,      CH4T2SAV, JCH4GASO2,
     .        JGAS,     SO40,      SO41,     SO42,     SO42AV,
     .        SO4T1,    SO4T2,     SO4T2AV,  SO40MG,   SO41TM1,
     .        SO4T2TM1, JSO4,      SO4T2SAV, HS0
      REAL    KPOP1,    KPOP2,     KPOP3,    KPON1,     KPON2,
     .        KPON3,    KPOC1,     KPOC2,    KPOC3
      REAL    KTGB1,    KTGB2,     KHNB,     KHPB,                    !CFC NOV24
     $        KTBB,     NLB,       NPPB,     NH4AVL,
     $        NO3AVL,   KESED,     KEBALG,   KETOTL
      REAL*8  PON1,     PON1TM1,  PON2,     PON2TM1,  PON3,
     .        PON3TM1,  POC1,     POC1TM1,  POC2,     POC2TM1,
     .        POC3,     POC3TM1,  POP1,     POP1TM1,  POP2,
     .        POP2TM1,  POP3,     POP3TM1                    !as per jf 10/07/16  
      LOGICAL BENTHIC_OUTPUT, STEADY_STATE_SED, BALGAE_CALC, SALT_PART

***** Dimension declarations

      DIMENSION KPDIAG(3),       DPTHTA(3),       KNDIAG(3),
     .          DNTHTA(3),       KCDIAG(3),       DCTHTA(3) 
      REAL*8    PON1TM1S(NSBP),  PON2TM1S(NSBP),  PON3TM1S(NSBP),
     .          POC1TM1S(NSBP),  POC2TM1S(NSBP),  POC3TM1S(NSBP),
     .          POP1TM1S(NSBP),  POP2TM1S(NSBP),  POP3TM1S(NSBP) !as per jf 10/07/16 
      DIMENSION BENSTR1S(NSBP),  BFORMAXS(NSBP),    
     .          ISWBENS(NSBP),   PIPTM1S(NSBP)                   !as per jf 10/07/16 
      DIMENSION NH41TM1S(NSBP),  NH4T2TM1S(NSBP), NO31TM1S(NSBP),
     .          NO3T2TM1S(NSBP), HS1TM1S(NSBP),   HST2TM1S(NSBP),
     .          PO41TM1S(NSBP),  PO4T2TM1S(NSBP)
      DIMENSION CH4T2TM1S(NSBP), SO4T2TM1S(NSBP), CH41TM1S(NSBP)       !CH4
      DIMENSION BURIALN(NSBP),   BURIALP(NSBP),   BURIALC(NSBP),
     .          DIAGENC(NSBP)
      DIMENSION ZHTADP(350),     ZHTADD(350),     ZHTANH4F(350),
     .          ZHTA1NO3(350),   ZHTA2NO3(350),   ZHTAD1(350),
     .          ZHTAP1(350),     ZL12NOM(350),
     .          ZW12NOM(350),    ZHTAPON1(350),   ZHTAPON2(350),
     .          ZHTAPON3(350),   ZHTAPOC1(350),   ZHTAPOC2(350),
     .          ZHTAPOC3(350),   ZHTAPOP1(350),   ZHTAPOP2(350),
     .          ZHTAPOP3(350),   ZHTACH4(350),    ZHTANH4S(350)
      DIMENSION AG3CFL(NSBP),    AG3NFL(NSBP),    AG3PFL(NSBP),
     .          ASDTMP(NSBP)
      DIMENSION FIB(NSBP),       NLB(NSBP),       PLB(NSBP),
     $          NPPB(NSBP),      BBM(NSBP),       BLITE(NSBP),
     $          BMB(NSBP),       PB(NSBP),        PRB(NSBP),
     $          BANH4(NSBP),     BANO3(NSBP),     BAPO4(NSBP),
     $          BADOC(NSBP),     BADO(NSBP),      BAPOC(NSBP),
     $          BAPON(NSBP),     BAPOP(NSBP)

***** Equivalence declarations

      EQUIVALENCE (KPDIAG(1),KPOP1),    (KPDIAG(2),KPOP2),
     .            (KPDIAG(3),KPOP3),    (KNDIAG(1),KPON1),
     .            (KNDIAG(2),KPON2),    (KNDIAG(3),KPON3),
     .            (KCDIAG(1),KPOC1),    (KCDIAG(2),KPOC2),
     .            (KCDIAG(3),KPOC3),    (DPTHTA(1),THTAPOP1),
     .            (DPTHTA(2),THTAPOP2), (DPTHTA(3),THTAPOP3),
     .            (DNTHTA(1),THTAPON1), (DNTHTA(2),THTAPON2),
     .            (DNTHTA(3),THTAPON3), (DCTHTA(1),THTAPOC1),
     .            (DCTHTA(2),THTAPOC2), (DCTHTA(3),THTAPOC3)

***** Common declarations

      COMMON /INPUTC/ M1,       M2,       DP,       W2,       DD,
     .                THTADP,   THTADD,   KAPPNH4,  PIENH4,   THTANH4,
     .                KMNH4,    KMNH4O2,  KAPP1NO3, K2NO3,    THTANO3,
     .                KAPPD1,   KAPPP1,   PIE1S,    PIE2S,    THTAPD1,
     .                KMHSO2,   H2,       DPIE1PO4, PIE2PO4,
     .                O2CRIT,   KMO2DP,   TEMPBEN,  KAPCH4,   KMCH4O2,
     .                KBENSTR,  KAPPCH4,  THTACH4,  KPDIAG,   DPTHTA,
     .                KNDIAG,   DNTHTA,   KCDIAG,   DCTHTA,   DPMIN,
     .                KLBNTH,   KMSO4,    k1no3,    kpie2,    kdpie1
      COMMON /LOGSC1/ BENTHIC_OUTPUT,     STEADY_STATE_SED, 
     $                BALGAE_CALC,        SALT_PART
      COMMON /SEDPOM/ PON1TM1S, PON2TM1S, PON3TM1S, POC1TM1S, POC2TM1S,
     .                POC3TM1S, POP1TM1S, POP2TM1S, POP3TM1S, 
     .                BENSTR1S, BFORMAXS, ISWBENS,  CH4T2TM1S,SO4T2TM1S,
     .                CH41TM1S, PIPTM1S
      COMMON /CONCC1/ NH41TM1S, NH4T2TM1S,NO31TM1S, NO3T2TM1S,HS1TM1S,
     .                HST2TM1S, PO41TM1S, PO4T2TM1S
      COMMON /CONCC2/ NH40,     NH41,     NH42,     NH4T1,    NH4T2,
     .                NH41TM1,  NH4T2TM1, JNH4,     NO30,     NO31,
     .                NO32,     NO3T1,    NO3T2,    NO31TM1,  NO3T2TM1,
     .                JNO3,     HS0,      HS1,      HS2,      HST1,
     .                HST2,     HS1TM1,   HST2TM1,  JHS,      
     .                PO40,     PO41,     PO42,
     .                PO4T1,    PO4T2,    PO41TM1,  PO4T2TM1, JPO4,
     .                JCH4AQ,   JCH4G,    CH40,     CH41,     CH42,
     .                CH42AV,   CH4T1,    CH4T2,    CH4T2AV,  CH41TM1,
     .                CH4T2TM1, JCH4,     CH4T2SAV, JCH4GASO2,
     .                JGAS,     SO40,     SO41,     SO42,     SO42AV,
     .                SO4T1,    SO4T2,    SO4T2AV,  SO40MG,   SO41TM1,
     .                SO4T2TM1, JSO4,     SO4T2SAV, PIPTM1
      COMMON /DIAGC/  PON1,     PON1TM1,  PON2,     PON2TM1,  PON3,
     .                PON3TM1,  POC1,     POC1TM1,  POC2,     POC2TM1,
     .                POC3,     POC3TM1,  POP1,     POP1TM1,  POP2,
     .                POP2TM1,  POP3,     POP3TM1,  XJN,      XJC,
     .                XJP,      XJCNO3,   XJCO2,
     .                XJC1,     JO2NH4,   SPIP
      COMMON /NLPARS/ K0H1D,    K0H1P,    K1H1D,    K1H1P,    K2H2D,
     .                K2H2P,    K3,       PIE1,     PIE2,     J1,
     .                J2,       KMC1,     W12,      KL12,     TEMPD,
     .                O20,      CH4SAT,   SAL
      COMMON /TSC/    SALTSW,   DLTS,     SALTND,   SALTLL,   SALTUL
      COMMON /STOREC/ XAPPNH4,  XAPPD1,   XAPPP1,   XAPP1NO3, XK2NO3,
     .                XAPPCH4,  TEMP20,   TEMP202,  FD1,
     .                FP1,      FD2,      FP2,      SOD,      CSOD,
     .                S,        W12NOM,   BENSTR,   BENSTRS,  BENSTR1,
     .                ISWBEN,   BFORMAX,  KL12NOM,  HSO4,     DDSO4,
     .                CSODHS,   CSODCH4
      COMMON /THETAS/ ZHTADP,   ZHTADD,   ZHTANH4,  ZHTANO3,  ZHTA2NO3,
     .                ZHTAD1,   ZHTAP1,   ZL12NOM,  ZW12NOM,  ZHTA1NO3,
     .                ZHTAPON1, ZHTAPON2, ZHTAPON3, ZHTAPOC1, ZHTAPOC2,
     .                ZHTAPOC3, ZHTAPOP1, ZHTAPOP2, ZHTAPOP3, ZHTACH4
      COMMON /SEDINT/ TINTIM, AG3CFL,  AG3NFL, AG3PFL,ASDTMP
      COMMON /BALG1/  KTGB1,  KTGB2,   TMB,    KHNB,  KHPB,      
     $                BMRB,   KTBB,    TRB,    PMB,   BPRB,   FNIB,
     $                ANCB,   FPIB,    APCB,   FCDB,  NH4AVL,
     $                NO3AVL, KESED,   KEBALG, KETOTL, BALGMIN
      COMMON /BALG2/  FIB,    NLB,     PLB,    NPPB,  BBM,    BLITE,
     $                BMB,    PB,      PRB,    BANH4, BANO3,  BAPO4,
     $                BADOC,  BADO,    BAPOC,  BAPON, BAPOP     

********************************************************************************
**                             SAV Model Setup                                **
********************************************************************************


***** Variable declarations

      CHARACTER*8 SPNAM,    EPINAM,   FRDEPTH
      REAL        KESAV,    KEEPI,    LEAF,
     $            NPPSAV,   NPPEPI,   LDOCSAV,   LDONSAVW,
     $            LPOCEPI,  LPOCSAV,  KHEP,      NLIMEPI,  LDOPSAVW
      REAL        KHNLEAF,  KHNROOT,  KHPLEAF,   KHPROOT,  KHNEPI,
     $            KHPEPI,   NLSAV,    NLEPI,     NH4SAVW,  NO3SAVW,
     $            LPONSAVW, NH4EPI,   NO3EPI,    LPOPSAVW, LPONEPI,
     $            LPOPEPI,  LDOCEPI,  LDONEPI,   LDOPEPI,  KHNPSAV,
     $            KHNPEPI
      REAL        SAVEFCT,  SAVSEFCT, DTHRESH,   EFSAVSTL
      INTEGER     SAVCELL,  NDOMSP,    DOMSP

***** Dimension declarations

      DIMENSION   SLSH(NSBP),           FPLEAF(366,NSAVP), 
     $            FPROOT(366,NSAVP),    FPSTEM(366,NSAVP), 
     $            FPTUBER(366,NSAVP),   TRTBRLF(366,NSAVP),
     $            SMLEAF(366,NSAVP)
     
      DIMENSION   SPNAM(NSAVP),         
     $            DOMSP(NSBP),          SAVDF(NSAVP),
     $            DTHRESH(NSAVP),       EFSAVSTL(NSAVP)

      DIMENSION   SAVDPH(NSBP),         SAVFRAC(NSBP),
     $            SAVCELL(NSBP),        SAVDPH_NX(NSBP)

      DIMENSION   EPATN(NSBP),          FISH(NSBP),
     $            PLEAF(NSBP),          SAVATN(NSBP),
     $            NPPSAV(NSBP),         NPPEPI(NSBP),
     $            DOSAV(NSBP),          LDOCSAV(NSBP),
     $            LPOCSAV(NSBP),        RPOCSAV(NSBP),
     $            DOEPI(NSBP),          LDOCEPI(NSBP),
     $            LPOCEPI(NSBP),        RPOCEPI(NSBP),
     $            LEAF(NSBP),           ROOT(NSBP),
     $            EP(NSBP),             FIEP(NSBP),
     $            WATATN(NSBP),
     $            RDOCSAV(NSBP),        RDOCEPI(NSBP),
     $            STEM(NSBP),           TUBER(NSBP),
     $            G3CSAV(NSBP),         G3NSAVW(NSBP),
     $            G3PSAVW(NSBP),        G3CEPI(NSBP),         
     $            G3NEPI(NSBP),         G3PEPI(NSBP) 

      DIMENSION   BMLEAF(NSBP),         BMSTEM(NSBP),   
     $            BMROOT(NSBP),         BMTUBER(NSBP)

      DIMENSION   NLSAV(NSBP),    FNSEDSAV(NSBP), PLSAV(NSBP),
     $            FPSEDSAV(NSBP), NH4SAVW(NSBP),  NO3SAVW(NSBP),
     $            LDONSAVW(NSBP), LPONSAVW(NSBP), RPONSAVW(NSBP),
     $            PO4SAVW(NSBP),  LDOPSAVW(NSBP), LPOPSAVW(NSBP),
     $            RPOPSAVW(NSBP), RDONSAVW(NSBP), RDOPSAVW(NSBP)

      DIMENSION   NLEPI(NSBP),    PLEPI(NSBP),    NH4EPI(NSBP),
     $            NO3EPI(NSBP),
     $            LDONEPI(NSBP),  LPONEPI(NSBP),  RPONEPI(NSBP),
     $            PO4EPI(NSBP),   LDOPEPI(NSBP),  LPOPEPI(NSBP),
     $            RPOPEPI(NSBP),  RDONEPI(NSBP),  RDOPEPI(NSBP)

      DIMENSION   PEP(NSBP),      BMEP(NSBP),
     $            PREP(NSBP)
     
      DIMENSION   SAVAREA(NSBP),  SEDCSAV(NSBP),  SEDDOSAV(NSBP),
     $            SEDNH4SAV(NSBP),SEDPO4SAV(NSBP),SEDNSAV(NSBP),
     $            SEDPSAV(NSBP),  SAVEFCT(NSBP),  SAVSEFCT(NSBP),
     $            SAVAREA_NX(NSBP)
     
      DIMENSION   FRCSAV(3),      FRNSAV(3),      FRPSAV(3)

      DIMENSION   FTPSAV(-50:400,NSAVP),  
     $            FTRSAV(-50:400,NSAVP),
     $            FTPEP(-50:400), FTREP(-50:400), FTPREP(-50:400)

      DIMENSION   PMSAV(NSAVP),   BMSAV(NSAVP),   BMTBRREF(NSAVP),
     $            ALPHSAV(NSAVP), KESAV(NSAVP),   
     $            FDOSR(NSAVP),   ALAC(NSAVP),    SALMAX(NSAVP),  
     $            PRSPSAVB(NSAVP),ACAN(NSAVP),    BCAN(NSAVP)

      DIMENSION   KHNLEAF(NSAVP), KHNROOT(NSAVP), KHPLEAF(NSAVP),  
     $            KHPROOT(NSAVP), KHNPSAV(NSAVP)

***** Common declarations

      COMMON /SAVSP1/ PMSAV,   BMSAV,    BMTBRREF,
     $               ALPHSAV,  KESAV,    FDOSR,
     $               ALAC,     TRTBRLF,  SLSAV,    SALMAX,
     $               PRSPSAVB, ACDWSAV,  ANDWSAV,  APDWSAV, HCAN,
     $               ANCSAV,   APCSAV,   ACAN,     BCAN,
     $               SMLEAF

      COMMON /SAVSP2/ KHNLEAF, KHNROOT,  KHPLEAF,  KHPROOT, FNISAV,
     $               FNLDSAV,  FNRDSAV,  FNLPSAV,  FNRPSAV, FPISAV,
     $               FPLDSAV,  FPRDSAV,  FPLPSAV,  FPRPSAV, FCLDSAV,
     $               FCRDSAV,  FCLPSAV,  FCRPSAV,  FDOSAV,  KHNPSAV,
     $               FNG3SAV,  FPG3SAV,  FCG3SAV

      COMMON /SAVSP3/WSSSAV,   WSLSAV,   WSRSAV,   WSG3SAV, WS1SAV,
     $               WS2SAV,   WS3SAV,   WSPIPSAV

      COMMON /SAVTMP/ FPLEAF,  FPROOT,   FPSTEM,   FPTUBER,
     $               FTPEP,    FTREP,    FTPREP,   FTPSAV,
     $               FTRSAV,   NDDI

      COMMON /SAVINC/ NSAVCELL,SAVDPH,   SAVFRAC,  SAVCELL, SAVDPH_NX

      COMMON /PROPAG/ SAVDF 

      COMMON /EPISP1/ PMEPI,   BMEPI,    PREPI,    ALPHEPI, KEEPI,
     $               FCLDPEP,  FCRDPEP,  FCLPPEP,
     $               FCRPPEP,  PRSPEPI,  CCHLEPI,  ANCEPI,  APCEPI,
     $               ADWCEPI,  KHEP,     NLIMEPI

      COMMON /EPISP2/ FNIEPI,  FNLDEPI,  FNRDEPI,  FNLPEPI, FNRPEPI,
     $               FNIPEP,   FNLDPEP,  FNRDPEP,  FNLPPEP, FNRPPEP,
     $               FPIEPI,   FPLDEPI,  FPRDEPI,  FPLPEPI, FPRPEPI,
     $               FPIPEP,   FPLDPEP,  FPRDPEP,  FPLPPEP, FPRPPEP,
     $               FCLDEPI,  FCRDEPI,  KHNEPI,   KHPEPI,  KHNPEPI,
     $               FNG3EPI,  FPG3EPI,  FNG3PEP,  FPG3PEP, FCG3PEP

      COMMON /SAVKI/ SAVATN,   NPPSAV,   DOSAV,    LDOCSAV, LPOCSAV,
     $               RPOCSAV,  LEAF,     ROOT,     FISH,    NLSAV,
     $               PLSAV,    NH4SAVW,  NO3SAVW,  LDONSAVW,
     $               LPONSAVW, RPONSAVW, PO4SAVW,  LDOPSAVW,LPOPSAVW,
     $               RPOPSAVW, PLEAF,    SLSH,     STEM,    TUBER,
     $               RDOCSAV,  RDONSAVW, RDOPSAVW, BMSTEM,  BMROOT,
     $               BMTUBER,  BMLEAF,   G3CSAV,  G3NSAVW,  G3PSAVW

      COMMON /EPIKI/ EPATN,    NPPEPI,   DOEPI,    LDOCEPI,  LPOCEPI, 
     $               RPOCEPI,  EP,       FIEP,     NLEPI,    PLEPI,
     $               NH4EPI,   NO3EPI,   LDONEPI,  LPONEPI,  RPONEPI,
     $               PO4EPI,   LDOPEPI,  LPOPEPI,  RPOPEPI,  PEP,
     $               BMEP,     PREP,     WATATN,   RDOCEPI,  RDONEPI,
     $               RDOPEPI,  G3CEPI,   G3NEPI,   G3PEPI
     
      COMMON /SAVCHA/ SPNAM,   EPINAM,   NDOMSP,   DOMSP
      
      COMMON /SAVLD/ SAVAREA,  SAVEFCT,  SAVAREA_NX
      
      COMMON /SAVSED/ SEDCSAV, FRCSAV,   FRNSAV,   FRPSAV,   FNSEDSAV,
     $               FPSEDSAV, SEDDOSAV, SEDNH4SAV,SEDPO4SAV,SEDNSAV,
     $               SEDPSAV  

c **** Suspension Feeders ****

      LOGICAL SFEEDER, HYPOXFX

      INTEGER SEDTYPE(NSBP,NSSFP)

      CHARACTER*8 AQUACULTURE(NSSFP)

      REAL FILT(NSSFP),   SFA1(NSSFP),  SFA2(NSSFP),  SFA3(NSSFP),  
     .     SFA4(NSSFP),   SFA5(NSSFP),  SFPRPWR(NSSFP),
     .     MAXING(NSSFP), SFCN(NSSFP),  SFCP(NSSFP),  
     .     NYUIJ(NSBP,NSSFP),           SFRESP(NSSFP), 
     .     SFPRED(NSBP,NSSFP),          SFTMN(NSSFP), 
     .     TOPTSF(NSSFP), KTG1SF(NSSFP),KTG2SF(NSSFP),SFTD(NSSFP),   
     .     BMRSF(NSSFP),  RFSF(NSSFP),  HARVEST(NSBP,NSSFP),
     .     SFDOH(NSSFP),  SFDOQ(NSSFP), SPCFCPR(NSSFP),
     .     SCOVER(NSBP,NSSFP)

      REAL SFLUXC(NSBP),  SFLUXN(NSBP),  SFLUXP(NSBP), SF_RPOC(NSBP)
     .    ,SF_RPON(NSBP), SF_RPOP(NSBP), JNH4SF(NSBP), JPO4SF(NSBP)
     .    ,SODSF(NSBP),   SF_FC(4,NSBP)
     .    ,SF_SSI(NSBP),  SF_PIP(NSBP)
     .    ,SFEED(NSBP,NSSFP),            SF_CLY(NSBP), SF_SLT(NSBP) 
     .    ,SF_ORG(NSBP),  SF_LDOC(NSBP)
     .    ,SF_CFILT(NSBP),SF_NFILT(NSBP),SF_PFILT(NSBP) 
     .    ,SF_G3C(NSBP),  SF_G3N(NSBP),  SF_G3P(NSBP)
 
CMBM 961226 sfeeder diagnostic arrays for output from main, inc in SUSFDERS cmn
      REAL SFFILTCT(NSBP,NSSFP),SFRESPCT(NSBP,NSSFP),
     .     SFPREDCT(NSBP,NSSFP),SFRATEI(NSBP,NSSFP), 
     .     SFGCMAX(NSBP,NSSFP), SFGMIN(NSBP,NSSFP),
     .     SFGCING(NSBP,NSSFP), SFCFECES(NSBP,NSSFP),
     .     SFNFECES(NSBP,NSSFP),SFPFECES(NSBP,NSSFP),
     .     SFCPSFEC(NSBP,NSSFP),SFNPSFEC(NSBP,NSSFP),
     .     SFPPSFEC(NSBP,NSSFP)

      REAL SF_SFGC(NSBP,NSSFP),   SF_RESP(NSBP,NSSFP)
     .    ,SF_PRED(NSBP,NSSFP),   SF_RMORT(NSBP,NSSFP)
     .    ,ASF_SFGC(NSBP,NSSFP), ASF_RESP(NSBP,NSSFP)
     .    ,ASF_PRED(NSBP,NSSFP), ASF_RMORT(NSBP,NSSFP)
     .    ,CHARV(NSBP,NSSFP),    FR_RSUSP(NSBP,NSSFP)

      COMMON /SUSFDERS/ 
     .     SFLUXC,   SFLUXN,   SFLUXP,  SF_RPOC, SF_LDOC
     .    ,SF_RPON,  SF_RPOP,  JNH4SF,  JPO4SF
     .    ,SODSF,    CHARV,    SF_SSI,   SF_PIP 
     .    ,SFEED,    SEDTYPE,  FR_RSUSP 
     .    ,FILT,     SFA1,     SFA2,    SFA3,    SFA4,    SFA5
     .    ,MAXING,   HARVEST,  NYUIJ,   SCOVER
     .    ,SFCN,     SFCP,     SFRESP,  SFPRED,  SFTMN,   TOPTSF
     .    ,KTG1SF,   KTG2SF,   SFTD,    SFPRPWR      
     .    ,BMRSF,    RFSF,     SFFILTCT,SFRESPCT,SFPREDCT
     .    ,SFRATEI,  SFGCMAX,  SFGMIN,  SFGCING, SFCFECES
     .    ,SFNFECES, SFPFECES, SFCPSFEC,SFNPSFEC,SFPPSFEC
     .    ,SFDOH,    SFDOQ,    SPCFCPR, FRDOCSF
     .    ,NSPECIES, SF_CLY,   SF_SLT,  SF_ORG,  SF_FC
     .    ,SF_SFGC,  SF_RESP,  SF_PRED, SF_RMORT
     .    ,ASF_SFGC, ASF_RESP, ASF_PRED,ASF_RMORT    
     .    ,SF_CFILT, SF_NFILT, SF_PFILT
     .    ,SF_G3C,   SF_G3N,   SF_G3P

      COMMON /SFDRS/ SFEEDER, AQUACULTURE
      COMMON /INFAUNA/ HYPOXFX

      END MODULE WQM

      function satdo(s,t) result(sat_conc)
!     Compute saturation DO concentration as a function of temperature
!     and salinity according to relations of Benson and Krause.  
!     Assume pressure of 1 atm 

      implicit none
      real :: s, t, degk, sal, f_of_t, f_of_s, sat_conc

      degk = t + 273.15
      sal = max(0.,s)
      f_of_t = -139.34411 + 1.575701e5/degk - 6.642308e7/degk**2 
     $  + 1.2438e10/degk**3 - 8.621949e11/degk**4
      sat_conc = exp(f_of_t)

      f_of_t = 0.017674 - 10.754/degk + 2140.7/degk**2
      f_of_s = exp(-s*f_of_t)
      sat_conc = sat_conc * f_of_s

      end function satdo

      MODULE WQM_INIT
      USE SIZES

***** Variable declarations

      INTEGER   DLTDP,    SNPDP,    TFLDP,    PLTDP,  APLDP,
     .          OPLDP,    DIADP
      INTEGER   COURB,    COURFS,   COURBS,   QD(0:NQFP),  F,
     .          SB,       S1LNMAX,  S2LNMAX,  S3LNMAX,  DIFFFS, DIFFBS  
      REAL      NXSNP,    NXPLT,    NXAPL,    NXTFL,    NXKFL,  NXTVD,
     .          NXOPL,    NXDIA,    NO3T2I,   NH4T2I,
     .          LEAFI,    STEMI,    ROOTI,    TUBERI

      REAL      MAXDLT,   MXDLT
      REAL      KFLD,     KFLF
      REAL*8    AT,       BT,       CT,       DT,       GAMMA,
     .          BTA,      VT,       TM1,      TM2,      TM3
      REAL*8    CR1,      CR2,      GAMFM1,   GAMF,     WDILB,  
     .          WDIB,     WAILB,    WAIB,     MINSTEP, 
     .          CL1,      CL2              !CFC   070105
      CHARACTER SNPC*3,   S1C*3,
     .          S2C*3,    MDC*3,    PLTC*3,   ACC*3,    FLC*3,
     .          BFC*3,    VBC*3,    QPLTC*3,  XYDFC*3,
     .          ZDFC*3,   ICOC*3,   ATMC*3,   SAVLC*3,  SEDC*3,
     .          AUTOC*3,  SPLTC*3,  HTFLC*3,  VTFLC*3,  STFLC*3,
     .          DIAC*3,   STLC*3,   SEDTR*3,
     .          APLTC*3,  KFLC*3,   OPLC*3,   BFOC*3,   S3C*3,
     .          SAVMC*3,  SAVPLTC*3,SFLC*3,   wtlmc*3
      CHARACTER EXT1*1,   EXT2*2,   EXT3*3,   EXT4*4
      CHARACTER SLC*8,    HYDC*8,   BNDTC*8,  CONSC*8,  ICIC*8   
      CHARACTER TIMEA*8,  TIMEB*8,  SPVARM*8, PRINTM*8
      CHARACTER TITLE*72, OLDTITLE*72,        FILENAME*72
      CHARACTER MAPFN*72, GEOFN*72, ICIFN*72, 
     .          AGRFN*72, STLFN*72, MRLFN*72, KFLFN*72, ICOFN*72
      CHARACTER SNPFN*72, PLTFN*72, APLFN*72, DIAFN*72, TFLFN*72,
     .          OPLFN*72, SUSFN*72, SUDFN*72, SAVFN*72
      character wetlands_input*72, wetlands_opt*72
      LOGICAL   SNAPSHOTS,  END_RUN,
     .          LEFT_FLOWB(NHQP), RIGHT_FLOWB(NHQP),
     .          LEFTM1_BOUNDARY(NHQP), RIGHTP1_BOUNDARY(NHQP),
     .          VOLUME_BALANCE,
     .          QUICKEST,         UPWIND,           ICOND_OUT,
     .          UNI_ICON_IN,      BIN_ICON_IN,
     .          AUTO_STEPPING,    STOP_RUN,
     .          PLOTS,            OXYGEN_PLOTS,     NEW_VOLUMES
      LOGICAL   TEMPERATURE_CALC, ALGAE_CALC,
     .          CARBON_CALC,      NITROGEN_CALC,    PHOSPHORUS_CALC,
     .          COD_CALC,         OXYGEN_CALC

***** Dimension declarations

      DIMENSION DEN1(NHQP,2),    DEN2(NHQP,2),     DEN3(NHQP,2),
     .          TP1(NHQP,2),     TP2(NHQP,2),      TP3(NHQP,2),
     .          T2(NHQP,2),      SF2(NHQP,2)
      DIMENSION T1(NHQP),        T3(NHQP),         SF1(NHQP)
      DIMENSION TERM1(NHQP),     TERM2(NHQP),      TERM3(NHQP),
     .          GRAD1(NHQP),     GRAD2(NHQP),      GRAD3(NHQP),
     .          COUR(NHQP)
    
      DIMENSION GRAD(NHQP,3),TERM(NHQP,3),IFLOWP(NBCP),IBT(NHQP),
     &          COURBSV(NHQP),COURVSV(NHQP)
      EQUIVALENCE (GRAD1,GRAD(1,1)),(GRAD2,GRAD(1,2)),(GRAD3,GRAD(1,3))
      EQUIVALENCE (TERM1,TERM(1,1)),(TERM2,TERM(1,2)),(TERM3,TERM(1,3))

      DIMENSION CR1(0:NLP,NSBP), CR2(0:NLP,NSBP),  GAMFM1(NLP,NSBP),
     .          GAMF(NLP,NSBP),  WDILB(NLP,NSBP),  WDIB(NLP,NSBP),
     .          WAILB(NLP,NSBP), WAIB(NLP,NSBP),
     .          CL1(0:NLP,NSBP), CL2(0:NLP,NSBP)     ! CFC 070105
      DIMENSION DIFFS(NQFP)
      DIMENSION AT(NLP,NSBP),    BT(NLP,NSBP),     CT(NLP,NSBP)
      DIMENSION DT(NLP,NCP),     GAMMA(NLP,NCP),   BTA(NLP,NCP)
      DIMENSION VT(NBP,NCP)
      DIMENSION C1MIN(NBP,NCP),   C1MAX(NBP,NCP)
      DIMENSION V2VB(NBP),       DLBV(NBP)
      DIMENSION DOVDAYS(NBP,NOIP)
      DIMENSION OINT(NOIP)
      DIMENSION CIC(NCP),        ACC(NCP),
     .          COUT(NCP),       CPOPI(3),
     .          CPONI(3),        CPOCI(3),         SFEEDI(10)
      DIMENSION DLTD(NDP),       SNPD(NDP),  
     .          SNPF(NDP),       DLTVAL(NDP),      DLTMAX(NDP),
     .          DLTFTN(NDP),     PLTD(NDP),        PLTF(NDP),
     .          APLTD(NDP),      APLF(NDP),        TFLD(NDP),
     .          TFLF(NDP),       KFLD(NDP),        KFLF(NDP),
     .          OPLD(NDP),       OPLF(NDP),        DIAD(NDP),
     .          DIAF(NDP)
      DIMENSION TITLE(6),        OLDTITLE(6)

      REAL SFEEDIN(NSBP,NSSFP)

***** Data declarations
      REAL :: DOCLIT= 0.0, LPOCLIT= 0.0, RPOCLIT= 0.0, PBSLIT= 0.0

******* SK - FOR SEDIMENT TRANSPORT
      REAL(8) BED_MASS_INT(NSBP,NSDCLS)
        
      END MODULE WQM_INIT



!.... PARALLEL SECTION BEGINS
#ifdef PARALLEL
      MODULE MESSENGER
      USE SIZES;  USE FILE_INFO

C*************************************************************************
C  Module for message-passing interface for Parallel CE-QUAL-ICM
C  The Message Passing Tables and Buffers are declared here
C*************************************************************************
C
C  VARIABLE Definitions:
C
C  NPES                     =  Number of PEs.   ( MPI communicator size )
C
C  MYPROC            =  PE number within MPI_WORLD_COMM communicator
C  NUM_COMM_PE       =  Number of communicating PE's ( read in )
C
C  NUM_RES_BLOCKS    =  Number of Blocks the PE owns
C  RES_BLOCK_NUM(I)  =  Local block number of resident block I
C
C  SEND_PE_NUM(I)    =  Target PE Numbers
C  RECV_PE_NUM(I)    =  Source PE Numbers
C
C  NUM_BL_SEND(I)    =  Number of Blocks to send to SEND_PE_NUM(I)
C  NUM_BL_RECV(I)    =  Number of Blocks to receive from RECV_PE_NUM(I)
C
C  SEND_BL_NUM(J,I)  =  Send-Block-List corresponds to SEND_PE_NUM(I)
C  RECV_BL_NUM(J,I)  =  Receive-Block-List corresponds to RECV_PE_NUM(I)
C
C  BUFSIZ4           =  Word size of Concentration Send/Receive Buffers
C  BUFSIZ8           =  Word size of Volumes Send/Receive Buffers
C
C  CONC_REQ          =  MPI Requests Buffer for Concentration 
C  CONC_STAT         =  MPI_STATUS Buffer for Concentration 
C  SEND_CONC         =  Concentrations Send Buffer
C  RECV_CONC         =  Concentrations Recv Buffer
C
C  VOLS_REQ          =  MPI Requests Buffer for Volumes
C  VOLS_STAT         =  MPI_STATUS Buffer for Volumes 
C  SEND_VOLS         =  Volumes Send Buffer
C  RECV_VOLS         =  Volumes Recv Buffer
C
C**************************************************************************
C
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
      INTEGER :: MYPROC, NPES 
      INTEGER :: NACC
      INTEGER :: NUM_COMM_PE, NUM_RES_BLOCKS
      INTEGER :: BUFSIZ4 = 3*NBP*NCP+3*NCP
      INTEGER :: BUFSIZ8 = 3*NBP 

      INTEGER,ALLOCATABLE ::  RES_BLOCK_NUM(:)
      INTEGER,ALLOCATABLE ::  SEND_PE_NUM(:)
      INTEGER,ALLOCATABLE ::  RECV_PE_NUM(:)
      INTEGER,ALLOCATABLE ::  NUM_BL_SEND(:)
      INTEGER,ALLOCATABLE ::  NUM_BL_RECV(:)
      INTEGER,ALLOCATABLE ::  RECV_BL_NUM(:,:)
      INTEGER,ALLOCATABLE ::  SEND_BL_NUM(:,:)
      INTEGER,ALLOCATABLE ::  CONC_REQ(:)
      INTEGER,ALLOCATABLE ::  CONC_STAT(:,:)
      INTEGER,ALLOCATABLE ::  VOLS_REQ(:)
      INTEGER,ALLOCATABLE ::  VOLS_STAT(:,:)
      INTEGER,ALLOCATABLE ::  NDEX(:)


      REAL(4),ALLOCATABLE ::  SEND_CONC(:,:)
      REAL(4),ALLOCATABLE ::  RECV_CONC(:,:)
      REAL(8),ALLOCATABLE ::  SEND_VOLS(:,:)
      REAL(8),ALLOCATABLE ::  RECV_VOLS(:,:)
C
C---------------------end of data declarations--------------------------------C

      CONTAINS


      SUBROUTINE COMM_INIT(MYPROC)
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
      INTEGER IERR
C
C** Initialize MPI get MPI rank, NPES and Read Communication Tables
C
      CALL MPI_INIT(IERR)
      CALL MPI_COMM_RANK(MPI_COMM_WORLD, MYPROC, IERR)
      CALL MPI_COMM_SIZE(MPI_COMM_WORLD, NPES, IERR)

      ALLOCATE ( RES_BLOCK_NUM(NBP) )
      ALLOCATE ( RECV_PE_NUM(NPES) )
      ALLOCATE ( SEND_PE_NUM(NPES) )
      ALLOCATE ( NUM_BL_SEND(NPES) )
      ALLOCATE ( NUM_BL_RECV(NPES) )
      ALLOCATE ( RECV_BL_NUM(NBP,NPES) )
      ALLOCATE ( SEND_BL_NUM(NBP,NPES) )
      ALLOCATE ( CONC_REQ(2*NPES) )
      ALLOCATE ( CONC_STAT(MPI_STATUS_SIZE,2*NPES) )
      ALLOCATE ( VOLS_REQ(2*NPES) )
      ALLOCATE ( VOLS_STAT(MPI_STATUS_SIZE,2*NPES) )

      CALL COMM_MSG_TABLE()   ! Read message-passing tables

      ALLOCATE ( NDEX(2*NPES) )
      ALLOCATE ( SEND_CONC(BUFSIZ4,NPES) )
      ALLOCATE ( RECV_CONC(BUFSIZ4,NPES) )
      ALLOCATE ( SEND_VOLS(BUFSIZ8,NPES) )
      ALLOCATE ( RECV_VOLS(BUFSIZ8,NPES) )

      CALL MESSAGE_START()    ! Initialize Persistent Message-Passing
C
      RETURN
      END SUBROUTINE


      SUBROUTINE COMM_EXIT()
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
      INTEGER I, IERR
C
C** Shutdown MPI library properly before exiting program
C
      DEALLOCATE ( RES_BLOCK_NUM )
      DEALLOCATE ( RECV_PE_NUM )
      DEALLOCATE ( SEND_PE_NUM )
      DEALLOCATE ( NUM_BL_SEND )
      DEALLOCATE ( NUM_BL_RECV )
      DEALLOCATE ( RECV_BL_NUM )
      DEALLOCATE ( SEND_BL_NUM )
      DEALLOCATE ( CONC_REQ )
      DEALLOCATE ( CONC_STAT )
      DEALLOCATE ( VOLS_REQ )
      DEALLOCATE ( VOLS_STAT )
      DEALLOCATE ( SEND_CONC )
      DEALLOCATE ( RECV_CONC )
      DEALLOCATE ( SEND_VOLS )
      DEALLOCATE ( RECV_VOLS )
      DEALLOCATE ( NDEX )

      CALL COMM_BARRIER()
      CALL MPI_FINALIZE(IERR)
C
      IF (MYPROC.EQ.0)  
     &  print *, "MPI terminated with Status = ",IERR      

C
      RETURN
      END SUBROUTINE



      SUBROUTINE COMM_DLT( )
      USE SIZES
      USE WQM
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
      INTEGER  IERR, LEN
      REAL(8) LOCAL(2),GLOBAL(2)

C
C** Find minimum timestep required by all PEs for stability.
C
      LEN   = 2
      LOCAL(1) = DLT8
      LOCAL(2) = MAXDLTDP
      CALL MPI_ALLREDUCE ( LOCAL, GLOBAL, LEN, MPI_REAL8,
     .                     MPI_MIN, MPI_COMM_WORLD,IERR )
      DLT8     = GLOBAL(1)
      MAXDLTDP = GLOBAL(2)
c     write(snp,*) "local  dlt = ", local(1)
c     write(snp,*) "global dlt = ", global(1)
c     write(snp,*) "local  maxdltdp = ", local(2)
c     write(snp,*) "global maxdltdp = ", global(2)

      RETURN
      END SUBROUTINE


      SUBROUTINE COMM_MSG_TABLE()
      USE WQM
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
      INTEGER IERR, ITEMP, I, J, MSG
      CHARACTER(72) MSGFN, TEMP_FILE_NAME
      CHARACTER(8) HEAD
c
c************************************************************************
c  This subroutine reads the communication table and obtains path
c  of local control file.
c************************************************************************
c
      MSG  = 60
      MSGFN = 'PE0000/wqm_msg.npt'
      WRITE(MSGFN(3:6),'(I4.4)') MYPROC
      OPEN(MSG, FILE=MSGFN, STATUS = 'OLD')
C
      READ(MSG,3005)  NACC   ! number active constituents
C
      READ (MSG,3010) ITEMP, NUM_RES_BLOCKS
      READ (MSG,1130) (RES_BLOCK_NUM(I), I=1,NUM_RES_BLOCKS)
C
      READ (MSG,3020) NUM_COMM_PE
      IF (NUM_COMM_PE.GT.NPES) THEN
         WRITE(6,*)'Number of Communicating PEs is greater than the',
     &             ' the total number of processors declared'
          STOP 'in COMM_MSG_TABLE'
      ENDIF
C
      DO I = 1,NUM_COMM_PE
         READ (MSG,3030) RECV_PE_NUM(I), NUM_BL_RECV(I)
c        write(*,3030) RECV_PE_NUM(I), NUM_BL_RECV(I)
         READ (MSG,1130) (RECV_BL_NUM(J,I), J=1, NUM_BL_RECV(I))
c        write(*,1130) (RECV_BL_NUM(J,I), J=1, NUM_BL_RECV(I))
      ENDDO
C
      DO I = 1,NUM_COMM_PE
         READ (MSG,3030) SEND_PE_NUM(I), NUM_BL_SEND(I)
c        write(*,3030) SEND_PE_NUM(I), NUM_BL_SEND(I)
         READ (MSG,1130) (SEND_BL_NUM(J,I), J=1, NUM_BL_SEND(I))
c        write(*,1130) (SEND_BL_NUM(J,I), J=1, NUM_BL_SEND(I))
      ENDDO

      TEMP_FILE_NAME = 'PE0000/'//CONFN
      WRITE(TEMP_FILE_NAME(3:6),'(I4.4)') MYPROC
      CONFN = TEMP_FILE_NAME
      WRITE(6,*)'CONTROL FILE FOR PE = ',MYPROC,' is ',CONFN
      TEMP_FILE_NAME = 'PE0000/'//SEDCONFN
      WRITE(TEMP_FILE_NAME(3:6),'(I4.4)') MYPROC
      SEDCONFN = TEMP_FILE_NAME
      WRITE(6,*)'CONTROL FILE FOR PE = ',MYPROC,' is ',SEDCONFN
C
      RETURN
1130  FORMAT(8X,9I8)   
3005  FORMAT(8X,I8)    
3010  FORMAT(8X,2I8)    
3020  FORMAT(8X,I8)    
3030  FORMAT(8X,2I8)    
      END SUBROUTINE



      SUBROUTINE MESSAGE_START()
      USE WQM
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
C--------------------------------------------------------------------------
C  Setup MPI data structures for "persistent" message-passing.
C  vjp  6/15/2000
C--------------------------------------------------------------------------
      INTEGER I,NSEND,NRECV,SEND_PE,RECV_PE,IERR,TAG,TAG2,NUMPE
C
      TAG  = 100
      TAG2 = 200
      NUMPE = NUM_COMM_PE
C
C  Setup persistent structures for receiving concentrations
C
      DO I=1, NUMPE
        NRECV = 3*NACC*NUM_BL_RECV(I)
        RECV_PE = RECV_PE_NUM(I)
        CALL MPI_RECV_INIT( RECV_CONC(1,I), NRECV, MPI_REAL4,
     &    RECV_PE, TAG, MPI_COMM_WORLD, CONC_REQ(I), IERR)
      ENDDO
C
C  Setup persistent structures for sending concentrations
C
      DO I=1, NUMPE
        NSEND = (3*NACC)*NUM_BL_SEND(I)
        SEND_PE = SEND_PE_NUM(I)
        CALL MPI_SEND_INIT( SEND_CONC(1,I), NSEND, MPI_REAL4,
     &    SEND_PE, TAG, MPI_COMM_WORLD, CONC_REQ(I+NUMPE), IERR)
      ENDDO
C
C  Setup persistent structures for receiving volumes
C
      DO I=1, NUMPE
        NRECV = 3*NUM_BL_RECV(I)
        RECV_PE = RECV_PE_NUM(I)
        CALL MPI_RECV_INIT( RECV_VOLS(1,I), NRECV, MPI_REAL8,
     &    RECV_PE, TAG2, MPI_COMM_WORLD, VOLS_REQ(I), IERR)
      ENDDO
C
C  Setup persistent structures for sending volumes
C
      DO I=1, NUMPE
        NSEND = 3*NUM_BL_SEND(I)
        SEND_PE = SEND_PE_NUM(I)
        CALL MPI_SEND_INIT( SEND_VOLS(1,I), NSEND, MPI_REAL8,
     &    SEND_PE, TAG2, MPI_COMM_WORLD, VOLS_REQ(I+NUMPE), IERR)
      ENDDO
C
      RETURN
      END SUBROUTINE


      SUBROUTINE COMM_CONCS()
      USE WQM
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
      INTEGER  IERR, ITEMP, JC
      INTEGER  I, J, NSEND, NRECV, SEND_PE, RECV_PE, NUMPE, NUMREQ
c
c------------------------------------------------------------------------
c  This subroutine communicates the following data to the Ghost Boxes
c  using Non-Blocking Message Passing.
c
c  It communicates: Concentrations C1 and C2 arrays, and DTC.
c
c  Srinivas Chippada & Victor Parr  4/97
c------------------------------------------------------------------------
c
      NUMPE = NUM_COMM_PE
      NUMREQ = 2*NUMPE
c
c------------------------------------------------------------------------
c   Pack All Ghost Boxes Data into Send Buffer.
c------------------------------------------------------------------------
c
      DO I=1, NUMPE
         NSEND = 0
c pack C1 data
         DO JC = 1,NACC
         DO J=1,NUM_BL_SEND(I)
            NSEND=NSEND+1
            SEND_CONC(NSEND,I)=C1(SEND_BL_NUM(J,I),AC(JC))
         ENDDO
         ENDDO
c pack C2 data
         DO JC = 1,NACC
         DO J=1,NUM_BL_SEND(I)
            NSEND=NSEND+1
            SEND_CONC(NSEND,I)=C2(SEND_BL_NUM(J,I),AC(JC))
         ENDDO
         ENDDO
c pack DTC data
         DO JC = 1,NACC
         DO J=1,NUM_BL_SEND(I)
            NSEND=NSEND+1
            SEND_CONC(NSEND,I)=DTC(SEND_BL_NUM(J,I),AC(JC))
         ENDDO
         ENDDO
      ENDDO
c
c------------------------------------------------------------------------
c   Post Asynchronous Send/Receive of Ghost Boxes Data.
c------------------------------------------------------------------------
c
      CALL MPI_STARTALL ( NUMREQ, CONC_REQ, IERR )

c
      RETURN
      END SUBROUTINE


      SUBROUTINE WAIT_CONCS()
      USE WQM
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
      INTEGER  IERR, JC, I, J, NRECV, NUMPE, NUMREQ
      INTEGER NFINI, TOT, NX, N
c
c------------------------------------------------------------------------
c  This subroutine waits for the Ghost Box Concentrations message-passing
c  to complete and then unpacks the data into the destination arrays.
c
c  It communicates: Concentrations C1 and C2 arrays, and DTC.
c
c  vjp 5/97
c------------------------------------------------------------------------
c
      NUMPE = NUM_COMM_PE
      NUMREQ = 2*NUMPE
c
c------------------------------------------------------------------------
c   Wait for all sends and receives of Ghost Boxes Data to complete.
c------------------------------------------------------------------------
c
      TOT = 0
      DO WHILE (TOT.LT.NUMREQ)
         NFINI = 0
         DO N=1, NUMREQ
            NDEX(N) = 0
         ENDDO
         CALL MPI_WAITSOME( NUMREQ,CONC_REQ,NFINI,NDEX,CONC_STAT,IERR )
         TOT = TOT + NFINI
         DO N=1, NFINI
            IF (NDEX(N).GT.0.AND.NDEX(N).LE.NUMREQ)  THEN
              IF (NDEX(N).LE.NUMPE) THEN
                NX = NDEX(N)
                NRECV=0
                DO JC=1,NACC                    ! Upack C1 data
                DO J=1,NUM_BL_RECV(NX)
                   NRECV=NRECV+1
                   C1(RECV_BL_NUM(J,NX),AC(JC))=RECV_CONC(NRECV,NX)
                ENDDO
                ENDDO
                DO JC=1,NACC                    ! Upack C2 data
                DO J=1,NUM_BL_RECV(NX)
                   NRECV=NRECV+1
                   C2(RECV_BL_NUM(J,NX),AC(JC))=RECV_CONC(NRECV,NX)
                ENDDO
                ENDDO
                DO JC=1,NACC                    ! Upack DTC data
                DO J=1,NUM_BL_RECV(NX)
                   NRECV=NRECV+1
                   DTC(RECV_BL_NUM(J,NX),AC(JC))=RECV_CONC(NRECV,NX)
                ENDDO
                ENDDO
              ENDIF
            ENDIF
         ENDDO
      ENDDO
c
      RETURN
      END SUBROUTINE


      SUBROUTINE COMM_VOLS()
      USE WQM; USE FILE_INFO
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
      INTEGER  IERR, ITEMP, JC
      INTEGER  I, J, NSEND, NRECV, SEND_PE, RECV_PE, NUMPE, NUMREQ
c
c------------------------------------------------------------------------
c  This subroutine communicates the following data to the Ghost Boxes
c  using Non-Blocking Message Passing.
c
c  It communicates Volumes V1 and V2 arrays and BL(*,3).
c  vjp 5/97
c------------------------------------------------------------------------
c   Pack All Ghost Boxes Data into Send Buffer.
c------------------------------------------------------------------------
c
      NUMPE = NUM_COMM_PE
      NUMREQ = 2*NUMPE
c
      DO I=1, NUMPE
c
         NSEND = 0
c pack V1 data
         DO J=1,NUM_BL_SEND(I)
            NSEND=NSEND+1
            SEND_VOLS(NSEND,I)=V1(SEND_BL_NUM(J,I))
         ENDDO
c pack V2 data
         DO J=1,NUM_BL_SEND(I)
            NSEND=NSEND+1
            SEND_VOLS(NSEND,I)=V2(SEND_BL_NUM(J,I))
         ENDDO
c pack BL(*,3) data
         DO J=1,NUM_BL_SEND(I)
            NSEND=NSEND+1
            SEND_VOLS(NSEND,I)= BL(SEND_BL_NUM(J,I),3)
         ENDDO
      ENDDO
c
c------------------------------------------------------------------------
c   Post Asynchronous Send/Receive of Ghost Boxes Data.
c------------------------------------------------------------------------
c
      CALL MPI_STARTALL ( NUMREQ, VOLS_REQ, IERR )
c
      RETURN
      END SUBROUTINE


      SUBROUTINE WAIT_VOLS()
      USE WQM
#ifdef INTEL
      USE MPI
#else
      INCLUDE 'mpif.h'
#endif
      INTEGER IERR, ITEMP, JC, I, J, NRECV, NUMPE, NUMREQ
      INTEGER NFINI, TOT, NX, N
c
c------------------------------------------------------------------------
c  This subroutine waits for the Ghost Box Volumes message-passing
c  to complete and then unpacks the data into the destination arrays.
c
c  It communicates: Concentrations V1 and V2 arrays, and BL(*,3).
c
c  vjp 5/97
c------------------------------------------------------------------------
c
      NUMPE = NUM_COMM_PE
      NUMREQ = 2*NUMPE
c
c------------------------------------------------------------------------
c   Wait for all sends and receives of Ghost Boxes Data to complete.
c   Unpack All Ghost Boxes Data from Receive Buffer.
c------------------------------------------------------------------------
c
      TOT = 0
      DO WHILE (TOT.LT.NUMREQ)
         NFINI = 0
         DO N=1, NUMREQ
            NDEX(N) = 0
         ENDDO
         CALL MPI_WAITSOME( NUMREQ,VOLS_REQ,NFINI,NDEX,VOLS_STAT,IERR )
         TOT = TOT + NFINI
         DO N=1, NFINI
            IF (NDEX(N).GT.0.AND.NDEX(N).LE.NUMREQ)  THEN
              IF (NDEX(N).LE.NUMPE) THEN
                NX = NDEX(N)
                NRECV=0
                DO J=1,NUM_BL_RECV(NX)          ! Unpack V1
                   NRECV=NRECV+1
                   V1(RECV_BL_NUM(J,NX))=RECV_VOLS(NRECV,NX)
                ENDDO
                DO J=1,NUM_BL_RECV(NX)          ! Unpack V2
                   NRECV=NRECV+1
                   V2(RECV_BL_NUM(J,NX))=RECV_VOLS(NRECV,NX)
                ENDDO
                DO J=1,NUM_BL_RECV(NX)          ! Unpack BL(*,3)
                   NRECV=NRECV+1
                   BL(RECV_BL_NUM(J,NX),3)=RECV_VOLS(NRECV,NX)
                ENDDO
              ENDIF
            ENDIF
         ENDDO
      ENDDO
c
      RETURN
      END SUBROUTINE


      SUBROUTINE COMM_BARRIER()
C--------------------------------------------------------------------------
C   A sync point for all processors
C   vjp  10/14/04
C--------------------------------------------------------------------------
#ifdef INTEL
      USE MPI
      IMPLICIT NONE
#else
      IMPLICIT NONE
      INCLUDE 'mpif.h'
#endif
      INTEGER IERR
      CALL MPI_BARRIER(MPI_COMM_WORLD,IERR)
      RETURN
      END SUBROUTINE COMM_BARRIER


      END MODULE MESSENGER
#endif
!.... PARALLEL SECTION ENDS

