C A PROGRAM TO READ WATERSHED MODEL OUTPUT SENT BY THE BAY PROGRAM
C AND PRODUCE WATER-QUALITY MODEL INPUT.
C MAY 18, 2007

C MODIFIED FROM 
C /mnt/cercolx2/Phase_5_012208/make_npsloads_WSM_solids.F 

C This code writes out only active variables.  To go with model code
C in Mar_01_06. March 15, 2006

C PIP added as an active variable May 4, 2006

C THIS GOES WITH PHASE 5 LOADS SENT BY BAY PROGRAM FEB 22, 2007. 
C BAY PROGRAM USED ICM CELLS AND GAVE ME INDIVIDUAL YEAR FILES
C THEY REVERSED ORDER SO THAT ALL CELLS ARE GIVEN FOR A DAY,
C THEN GO GO NEXT DAY. PREVIOUSLY I HADD ALL DAYS FOR A CELL,
C THEN NEXT CELL.  I THINK I CAN DEAL WITH THIS BY REVERSING ORDER OF 
C MY I AND J INDICES ON READ STATEMENT.  ALSO, BAY PROGRAM DATA IS
C COMMA SEPARATED.  

C THESE LOADS INCLUDE SAND, SILT, CLAY, DRY PHYTOPLANKTON
C ISS loaded as state variable 3.  No TAM.  March 3, 2008 

C FOUR SEDIMENT CLASSES INCLUDING ORGS (FINE CLAY).  USE WSM SPLITS
C OF SAND, SILT, CLAY.  ORGS IS A CONSTANT CONCENTRATION.

C PROBLEM WITH MONTH = 13 IN LEAP YEARS FIXED AUG 4, 2011

C ZOOPLANKTON AND SILICA COMMENTED OUT IN PREPARATION FOR REMOVAL
C 11/10/14

C G3 ORGANICS ADDED, ZOOPLANKTON AND SILICA REMOVED 02/10/15

C Restore chlorophyll loads 10/20/15.  Start with make_npsload_G3_orgs.f  

C Calculate dissolved, particulate organics as fractions of total

C Explicit specification of G splits for carbon Oct 28, 2016
C Modified from make_npsload_patch_B3.f 

C This code goes with Phase_6_Beta_4 WSM.  Patches to chl and DIP
C for Phase_6_Beta_3 removed 02/23/17

C Install Qian Zhang's flow-variable G splits for the Susquehanna
C 04/20/17

C Modified to go with Phase 6 loads sent 060917.  Two header lines
C added to nps input files.  Zhang's splits retained.

      PARAMETER (NBP=2400, NTIM=366, NAC=36, NMON=12, NTOT=11500)
      
      DIMENSION YEAR(NTIM), WMONTH(NTIM), DAY(NTIM), JDAY(NTIM)

      DIMENSION CELL(NBP), ISS(NBP,NTIM), DOC(NBP,NTIM),
     $  LPOC(NBP,NTIM), RPOC(NBP,NTIM), NH4(NBP,NTIM), NO3(NBP,NTIM),
     $  DON(NBP,NTIM), LPON(NBP,NTIM), RPON(NBP,NTIM), PO4(NBP,NTIM),
     $  DOP(NBP,NTIM), LPOP(NBP,NTIM), RPOP(NBP,NTIM), G3OC(NBP,NTIM),
     $  G3ON(NBP,NTIM),G3OP(NBP,NTIM), B1(NBP,NTIM),   B2(NBP,NTIM),  
     $  B3(NBP,NTIM),  PIPOUT(NBP,NTIM), CLAY(NBP,NTIM),
     $  SILT(NBP,NTIM), SAND(NBP,NTIM), ORGS(NBP,NTIM),WCHL(NBP,NTIM)   

      DIMENSION ORGN(NBP,NTIM), ORGP(NBP,NTIM), TSS(NBP,NTIM), 
     $  FLOW(NBP,NTIM), TOC(NBP,NTIM), DO(NBP,NTIM), 
     $  PIP(NBP,NTIM), TEMP(NBP,NTIM)
     
      DIMENSION FCYANI(NMON), FDIATI(NMON)
      
      DIMENSION ANC1(NTOT), APC1(NTOT), CCHL1(NTOT),
     $  ANC2(NTOT), APC2(NTOT), CCHL2(NTOT), ANC3(NTOT),
     $  APC3(NTOT), CCHL3(NTOT),VSSTC(NTOT), C_TO_N(NTOT),
     $  FDON(NTOT), FLPON(NTOT),FDOP(NTOT), FLPOP(NTOT), PIP2PP(NTOT), 
     $  FCYAN(NTOT,NMON), FDIAT(NTOT,NMON),
     $  FRPON(NTOT), FRPOP(NTOT), FDOC(NTOT), FLPOC(NTOT), FRPOC(NTOT)
     
      REAL CORGS(NTOT), SUSQFLOW(NTIM)
     
      INTEGER OFACE(NBP)
     
      DIMENSION NLOAD(NAC)

      CHARACTER*4 PARM(NAC)
      CHARACTER*72 DSNIN, DSNOUT, TITLE(2), RIVER
      CHARACTER*1 CELLS_UNITS

      REAL JDAY, ISS, LPOC, NH4, NO3, LPON, LPOP, LZERO, FG1, FG2, FG3

      INTEGER YEAR, DAY, WMONTH, CELL

      DATA PARM /'TEMP','SALT',' ISS','CYAN','DIAT','GREN',
     $           'ZOO1','ZOO2','LDOC','RDOC',
     $           'LPOC','RPOC',' NH4',' NO3','UREA','LDON','RDON',
     $           'LPON','RPON',' PO4','LDOP','RDOP','LPOP','RPOP',
     $           ' PIP',' COD','  DO',' PBS','DSIL',
     $           'G3OC','G3ON','G3OP','CLAY','SILT','SAND','ORGS'/


C OPEN INPUT AND OUTPUT FILES

      OPEN(10,FILE='make_npsloads.npt',STATUS='OLD')
      READ(10,1) DSNIN
      READ(10,1) DSNOUT
      OPEN(11,FILE=DSNIN,STATUS='OLD')
      OPEN(12,FILE=DSNOUT,STATUS='UNKNOWN')
      OPEN(25,FILE='make_npsloads.opt',STATUS='UNKNOWN')

C ASSIGN JULIAN DAYS TO INPUTS, ASSIGN A FEW DUMMY VARIABLES

      DO I=1,366
        JDAY(I)=I-1
        SUSQFLOW(I) = 0.0
      END DO

      LZERO=0.

C READ HEADER LINES FOR OUTPUT FILE

      READ(10,6) TITLE(1)
      READ(10,5) TITLE(2)

C GET NUMBER OF CELLS AND DAYS

      READ(10,2) NCELL, NDAY, NMONTH
      
C READ PROPERTIES AT EACH FALL LINE
C READ NUMBER OF CELLS (NFACE) ASSIGNED TO THIS BOUNDARY CONDITON 
C FOR THE FIRST BOUNDARY CONDITION, NFACE SHOULD BE TOTAL NUMBER
C OF SURFACE CELLS 
      READ(10,5) RIVER    
      READ(10,*) NFACE  

C FIRST READ A SET OF GENERAL PROPERTIES AND ASSIGN TO ALL CELLS.
      READ(10,3) ANC1I,APC1I,CCHL1I
      READ(10,3) ANC2I,APC2I,CCHL2I
      READ(10,3) ANC3I,APC3I,CCHL3I
      READ(10,3) VSSTCI,C_TO_NI,FDONI,FLPONI,FRPONI,
     $  FDOPI,FLPOPI,FRPOPI,PIP2PPI
      READ(10,3) FDOCI, FLPOCI, FRPOCI, ORGSI
 3    FORMAT(/9F8.0)

C CHECK FRACTIONS
      IF (FLPONI+FRPONI .GT. 1.) WRITE (*,70) RIVER
 70   FORMAT('FLPON + FRPON > 1 AT ',A72)
      IF (FLPOPI+FRPOPI .GT. 1.) WRITE (*,71) RIVER
 71   FORMAT('FLPOP + FRPOP > 1 AT ',A72)
      IF (FLPOCI+FRPOCI .GT. 1.) WRITE (*,72) RIVER
 72   FORMAT('FLPOC + FRPOC > 1 AT ',A72)

C READ MONTHLY BOUNDARY CONDITIONS        
      READ(10,*) (FCYANI(I),I=1,NMONTH)
      READ(10,*) (FDIATI(I),I=1,NMONTH)

C ASIGN TO ALL CELLS
      DO I=1,NFACE
        ANC1(I) = ANC1I
        APC1(I) = APC1I
        CCHL1(I) = CCHL1I
        ANC2(I) = ANC2I
        APC2(I) = APC2I
        CCHL2(I) = CCHL2I
        ANC3(I) = ANC3I
        APC3(I) = APC3I
        CCHL3(I) = CCHL3I
        VSSTC(I) = VSSTCI
        C_TO_N(I) = C_TO_NI
        FDON(I) = FDONI
        FLPON(I) = FLPONI
        FRPON(I) = FRPONI
        FDOP(I) = FDOPI
        FLPOP(I) = FLPOPI
        FRPOP(I) = FRPOPI
	PIP2PP(I) = PIP2PPI
        FDOC(I) = FDOCI
        FLPOC(I) = FLPOCI
        FRPOC(I) = FRPOCI
	CORGS(I) = ORGSI
	DO J=1,NMONTH
          FCYAN(I,J) = FCYANI(J)
          FDIAT(I,J) = FDIATI(J)
	END DO
      END DO

C THEN READ SPECIFIC FALL LINES AND OVERRIDE GENERAL PROPERTIES

 20   READ(10,5) RIVER
      READ(10,*) NFACE  
      IF (NFACE.GT.-999) THEN        

C READ CELLS ASSOCIATED WITH THIS FALL LINE         
        READ(10,*) (OFACE(I),I=1,NFACE)
      
C READ PROPERTIES ASSOCIATED WITH THIS FALL LINE
        READ(10,3) ANC1I,APC1I,CCHL1I
        READ(10,3) ANC2I,APC2I,CCHL2I
        READ(10,3) ANC3I,APC3I,CCHL3I
        READ(10,3) VSSTCI,C_TO_NI,FDONI,FLPONI,FRPONI,
     $    FDOPI,FLPOPI,FRPOPI,PIP2PPI
        READ(10,3) FDOCI, FLPOCI, FRPOCI, ORGSI
C READ MONTHLY BOUNDARY CONDITIONS        
        READ(10,*) (FCYANI(I),I=1,NMONTH)
        READ(10,*) (FDIATI(I),I=1,NMONTH)

C ASIGN TO CELLS ASSOCIATED WITH THIS FALL LINE
        DO K=1,NFACE
          I=OFACE(K)
          ANC1(I) = ANC1I
          APC1(I) = APC1I
          CCHL1(I) = CCHL1I
          ANC2(I) = ANC2I
          APC2(I) = APC2I
          CCHL2(I) = CCHL2I
          ANC3(I) = ANC3I
          APC3(I) = APC3I
          CCHL3(I) = CCHL3I
          VSSTC(I) = VSSTCI
          C_TO_N(I) = C_TO_NI
          FDON(I) = FDONI
          FLPON(I) = FLPONI
          FRPON(I) = FRPONI
          FDOP(I) = FDOPI
          FLPOP(I) = FLPOPI
          FRPOP(I) = FRPOPI
	  PIP2PP(I) = PIP2PPI
          FDOC(I) = FDOCI
          FLPOC(I) = FLPOCI
          FRPOC(I) = FRPOCI
    	  CORGS(I) = ORGSI
	  DO J=1,NMONTH
            FCYAN(I,J) = FCYANI(J)
            FDIAT(I,J) = FDIATI(J)
	  END DO
        END DO
	GO TO 20
      END IF

C READ TWO HEADER LINES IN WSM FILE
      READ(11,*) CELLS_UNITS
      READ(11,*) CELLS_UNITS

C READ WATERSHED MODEL LOADS
C REVERSE ORDER OF READS TO GO WITH MAY 3, 2006, PHASE 5 WSM

      DO I=1,NDAY
        DO J=1,NCELL
          READ(11,*) CELL(J), YEAR(I), WMONTH(I), DAY(I), DO(J,I),
     $      TEMP(J,I), WCHL(J,I), FLOW(J,I), PO4(J,I),  
     $      NH4(J,I), NO3(J,I), TOTN, TOTP, ORGP(J,I), ORGN(J,I), 
     $      PIP(J,I), TOC(J,I), TSS(J,I), SAND(J,I), SILT(J,I),
     $      CLAY(J,I)
C OBTAIN SUSQUEHANNA FLOW
            IF (CELL(J) .EQ. 10850 .OR. CELL(J) .EQ. 10878 .OR. 
     $        CELL(J) .EQ. 10907) SUSQFLOW(I) = SUSQFLOW(I) + FLOW(J,I) 
        END DO
      END DO

C ASSIGN A CHLOROPHYLL CONCENTRATION TO EACH CELL,
C COMPUTE ALGAL CARBON LOADS, CORRECT ORGANIC N AND P FOR
C ALGAL CONTENT

      DO J=1,NCELL
        K=CELL(J)
        DO I=1,NDAY
	  MONTH = 1. + FLOAT(I)/30.42
	  MONTH = MIN(MONTH,12)
	  B1(J,I) = 0.0864 * WCHL(J,I) * FLOW(J,I) * CCHL1(K) 
     $      * FCYAN(K,MONTH)
          ORGN(J,I) = MAX(0.,ORGN(J,I) - ANC1(K) * B1(J,I))
          ORGP(J,I) = MAX(0.,ORGP(J,I) - APC1(K) * B1(J,I))
	  B2(J,I) = 0.0864 * WCHL(J,I) * FLOW(J,I) * CCHL2(K)
     $      * FDIAT(K,MONTH)
          ORGN(J,I) = MAX(0.,ORGN(J,I) - ANC2(K) * B2(J,I))
          ORGP(J,I) = MAX(0.,ORGP(J,I) - APC2(K) * B2(J,I))
	  B3(J,I) = 0.0864 * WCHL(J,I) * FLOW(J,I) * CCHL3(K)
     $      * (1. - FCYAN(K,MONTH) - FDIAT(K,MONTH))
          ORGN(J,I) = MAX(0.,ORGN(J,I) - ANC3(K) * B3(J,I))
          ORGP(J,I) = MAX(0.,ORGP(J,I) - APC3(K) * B3(J,I))
	END DO
      END DO

C SPLIT ORGANIC NITROGEN FRACTIONS, COMPUTE ORGANIC CARBON

      DO J=1,NCELL
        K=CELL(J)
        DO I=1,NDAY
          DON(J,I) = MAX(FDON(K) * ORGN(J,I), 0.0)
          PON = MAX(ORGN(J,I) - DON(J,I), 0.0)
          LPON(J,I) = FLPON(K) * PON
          RPON(J,I) = FRPON(K) * PON
          G3ON(J,I) = (1.-FLPON(K)-FRPON(K)) * PON
          IF ((K .EQ. 10850 .OR. K .EQ. 10878 .OR. K .EQ. 10907) .AND.
     $       SUSQFLOW(I) .GT.6500.) THEN
              WRITE(666,*) I, SUSQFLOW(I)
              FG1 = FLPON(K) -0.000749*(SUSQFLOW(I)-6500.)/100.
              FG2 = FRPON(K) -0.001638*(SUSQFLOW(I)-6500.)/100.
              FG3 = 1 - FG1 - FG2
              LPON(J,I) = FG1 * PON
              RPON(J,I) = FG2 * PON  
              G3ON(J,I) = FG3 * PON
          END IF          

C ASSIGN ORGANIC CARBON LOADS AS A MULTIPLIER OF ORGANIC N

          ORGC = C_TO_N(K) * (DON(J,I)+PON)
          DOC(J,I)  = FDOC(K) * ORGC
          POC = MAX(ORGC - DOC(J,I), 0.0)
          LPOC(J,I) = FLPOC(K) * POC
          RPOC(J,I) = FRPOC(K) * POC
          G3OC(J,I) = (1.-FLPOC(K)-FRPOC(K)) * POC
          IF ((K .EQ. 10850 .OR. K .EQ. 10878 .OR. K .EQ. 10907) .AND.
     $       SUSQFLOW(I) .GT.6500.) THEN
              FG1 = FLPOC(K) -0.000764*(SUSQFLOW(I)-6500.)/100.
              FG2 = FRPOC(K) -0.001330*(SUSQFLOW(I)-6500.)/100.
              FG3 = 1 - FG1 - FG2
              LPOC(J,I) = FG1 * POC
              RPOC(J,I) = FG2 * POC  
              G3OC(J,I) = FG3 * POC
          END IF

C REMOVE VOLATILE SOLIDS FROM TOTAL SOLIDS

          ISS(J,I) = TSS(J,I) - VSSTC(K) * (B1(J,I)+B2(J,I)+B3(J,I)
     $      +LPOC(J,I)+RPOC(J,I))
          ISS(J,I) = MAX(ISS(J,I),0.)

        END DO
      END DO

C SPLIT ORGANIC PHOSPHORUS FRACTIONS

      DO J=1,NCELL
        K=CELL(J)
        DO I=1,NDAY
          DOP(J,I) = MAX(FDOP(K) * (ORGP(J,I) + PIP(J,I)), 0.0)
          POP = MAX(ORGP(J,I) + PIP(J,I) - DOP(J,I), 0.0)
	  PIPOUT(J,I) = PIP2PP(K) * POP
          LPOP(J,I) = (1.-PIP2PP(K)) * FLPOP(K) * POP
          RPOP(J,I) = (1.-PIP2PP(K)) * FRPOP(K) * POP
          G3OP(J,I) = (1.-PIP2PP(K)) * (1.-FLPOP(K)-FRPOP(K)) * POP
          IF ((K .EQ. 10850 .OR. K .EQ. 10878 .OR. K .EQ. 10907) .AND.
     $       SUSQFLOW(I) .GT.6500.) THEN
              FG1 = FLPOP(K) -0.001091*(SUSQFLOW(I)-6500.)/100.
              FG2 = FRPOP(K) -0.000949*(SUSQFLOW(I)-6500.)/100.
              FG3 = 1 - FG1 - FG2
              LPOP(J,I) = FG1 * (1.-PIP2PP(K)) * POP
              RPOP(J,I) = FG2 * (1.-PIP2PP(K)) * POP  
              G3OP(J,I) = FG3 * (1.-PIP2PP(K)) * POP
          END IF
        END DO
      END DO

C ASSIGN FINE CLAY, SPLIT REMAINDER OF WSM SILT AND CLAY AS PER 
C WSM INPUTS

      DO J=1,NCELL
        K=CELL(J)
        DO I=1,NDAY
          ORGS(J,I) = MIN(CORGS(K) * FLOW(J,I) * 86.4 , 
     $      CLAY(J,I))
          CLAY(J,I) = CLAY(J,I) - ORGS(J,I)
        END DO
      END DO

C ASSIGN NPSLN FOR APPROPRIATE STATE VARIABLES

      DO I=1,2
        NLOAD(I) = 0                    ! temperature, salinity
      END DO
      NLOAD(3) = NCELL                  ! ISS
      NLOAD(4) = NCELL                  ! cyanobacteria
      NLOAD(5) = 0                      ! spring diatoms
      NLOAD(6) = NCELL                  ! green algae
      DO I=7,8
        NLOAD(I) = 0                    ! microzoo, mesozoo
      END DO
      NLOAD(9) = NCELL                  ! labile DOC
      NLOAD(10) = 0                     ! refract DOC
      DO I=11,14
        NLOAD(I) = NCELL                ! labile POC, refract POC, NH4, NO3
      END DO
      NLOAD(15)  = 0                   ! urea
      NLOAD(16) = NCELL                ! labile DON
      NLOAD(17) = 0                    ! refract DON
      DO I=18,21                  
        NLOAD(I) = NCELL               ! Labile PON, refract PON, PO4, labile DOP
      END DO
      NLOAD(22) = 0                    ! refract DOP
      NLOAD(23) = NCELL                ! labile POP
      NLOAD(24) = NCELL                ! refract POP
      NLOAD(25) = NCELL                ! PIP
      DO I=26,29                  
        NLOAD(I) = 0                  !COD, DO, PBS, dissolved silica
      END DO
      DO I=30,32                  
        NLOAD(I) = NCELL                !G3 organic particles
      END DO
      DO I=33,36                  
        NLOAD(I) = NCELL               !Solids CLAY, SILT, SAND, ORGS
      END DO
            
C THE NUMBERS ARE IN, NOW PUT THEM OUT IN MODEL FORMAT
C FIRST WRITE TITLE AND NUMBER OF LOADS

      WRITE(12,5) (TITLE(I),I=1,2)
      WRITE(12,60)
      WRITE(12,61) (NLOAD(I),I=1,36)
      
C WRITE DUMMY BOXES FOR FIRST TWO CONSTITUENTS

      DO I=1,2
        WRITE(12,62) PARM(I)
      END DO

C WRITE ACTUAL BOXES FOR SUSPENDED SEDIMENTS

      WRITE(12,63) PARM(3)
      WRITE(12,64) (CELL(J),J=1,NCELL)
      
C WRITE ACTUAL BOXES ALGAL GROUP 1

      WRITE(12,63) PARM(4)
      WRITE(12,64) (CELL(J),J=1,NCELL)
      
C WRITE DUMMY BOX FOR DIATOMS

      WRITE(12,62) PARM(5)

C WRITE ACTUAL BOXES ALGAL GROUP 3

      WRITE(12,63) PARM(6)
      WRITE(12,64) (CELL(J),J=1,NCELL)
      
C WRITE DUMMY BOXES FOR TWO CONSTITUENTS

C      DO I=7,8
C       WRITE(12,62) PARM(I)
C      END DO

C WRITE ACTUAL BOXES LABILE DOC

      WRITE(12,63) PARM(9)
      WRITE(12,64) (CELL(J),J=1,NCELL)
      
C WRITE DUMMY BOX FOR REFRACTORY DOC

C      WRITE(12,62) PARM(10)

C WRITE PARTICULATE CARBON, DISSOLVED INORGANIC NITROGEN LOCATIONS

      DO I=11,14
        WRITE(12,63) PARM(I)
        WRITE(12,64) (CELL(J),J=1,NCELL)
      END DO
      
C WRITE DUMMY BOX FOR UREA

C      WRITE(12,62) PARM(15)

C WRITE ACTUAL BOXES LABILE DON

      WRITE(12,63) PARM(16)
      WRITE(12,64) (CELL(J),J=1,NCELL)
      
C WRITE DUMMY BOX FOR REFRACTORY DON

C      WRITE(12,62) PARM(17)

C WRITE PARTICULATE NITROGEN, DISSOLVED INORGANIC, LABILE ORGANIC P

      DO I=18,21
        WRITE(12,63) PARM(I)
        WRITE(12,64) (CELL(J),J=1,NCELL)
      END DO
      
C WRITE DUMMY BOX FOR REFRACTORY DOP

C      WRITE(12,62) PARM(22)

C WRITE LOCATIONS FOR THREE FORMS OF PARTICULATE P

      DO I=23,25
        WRITE(12,63) PARM(I)
        WRITE(12,64) (CELL(J),J=1,NCELL)
      END DO
      
C WRITE DUMMY BOXES FOR COD, DO, BUT NOT DISSOLVED, PARTICULATE SILICA
C WAS DO I=26,29

      DO I=26,27
        WRITE(12,62) PARM(I)
      END DO
      
C WRITE BOXES FOR G3 ORGANIC PARTICLES

      DO I=30,32
        WRITE(12,63) PARM(I)
        WRITE(12,64) (CELL(J),J=1,NCELL)
      END DO
      
C WRITE FOUR SOLIDS FRACTIONS LOCATIONS

      DO I=33,36
        WRITE(12,63) PARM(I)
        WRITE(12,64) (CELL(J),J=1,NCELL)
      END DO
      
C PUT OUT LOADS

C FIRST WRITE HEADER LINE

      WRITE(12,65)

      DO I=1,NDAY
      
C PUT OUT DUMMY LOADS FOR FIRST TWO CONSTITUENTS

        DO J=1,2
          WRITE(12,66) PARM(J),JDAY(I),LZERO
        END DO

C PUT OUT SUSPENDED SEDIMENT LOADS

        IFLAG=0
        DO J=1,NCELL
          IF (ISS(J,I) .GT. 9999999) IFLAG=1
        END DO
        IF (IFLAG .EQ. 0) THEN
          WRITE(12,66) PARM(3),JDAY(I),(ISS(J,I),J=1,NLOAD(3))
        ELSE
          WRITE(12,67) PARM(3),JDAY(I),(ISS(J,I),J=1,NLOAD(3))
        END IF
        
C PUT OUT LOADS FOR ALGAL GROUP 1

        IFLAG=0
        DO J=1,NCELL
          IF (B1(J,I) .GT. 999999.) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(4),JDAY(I),(B1(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(4),JDAY(I),(B1(J,I),J=1,NCELL)
        END IF
        
C PUT OUT DUMMY LOAD FOR DIATOMS

        WRITE(12,66) PARM(5),JDAY(I),LZERO

C PUT OUT LOADS FOR ALGAL GROUP 3

        IFLAG=0
        DO J=1,NCELL
          IF (B3(J,I) .GT. 999999.) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(6),JDAY(I),(B3(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(6),JDAY(I),(B3(J,I),J=1,NCELL)
        END IF
        
C PUT OUT DUMMY LOADS FOR NEXT TWO CONSTITUENTS

C        DO J=7,8
C          WRITE(12,66) PARM(J),JDAY(I),LZERO
C        END DO
        
C PUT OUT DISSOLVED ORGANIC CARBON LOADS

        IFLAG=0
        DO J=1,NCELL
          IF (DOC(J,I) .GT. 9999999.) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,66) PARM(9),JDAY(I),(DOC(J,I),J=1,NCELL)
        ELSE
          WRITE(12,67) PARM(9),JDAY(I),(DOC(J,I),J=1,NCELL)
        END IF

C PUT OUT DUMMY LOAD FOR RDOC

C        WRITE(12,66) PARM(10),JDAY(I),LZERO

C PUT OUT POC LOADS	
	
        WRITE(12,66) PARM(11),JDAY(I),(LPOC(J,I),J=1,NCELL)
        IFLAG=0
        DO J=1,NCELL
          IF (RPOC(J,I) .GT. 999999.) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(12),JDAY(I),(RPOC(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(12),JDAY(I),(RPOC(J,I),J=1,NCELL)
        END IF

C PUT OUT DISSOLVED INORGANIC NITROGEN LOADS

        IFLAG=0
        DO J=1,NCELL
          IF (NH4(J,I) .GT. 999999) then
            IFLAG=1
          end if
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(13),JDAY(I),(NH4(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(13),JDAY(I),(NH4(J,I),J=1,NCELL)
        END IF
        WRITE(12,66) PARM(14),JDAY(I),(NO3(J,I),J=1,NCELL)
	
C PUT OUT DUMMY LOAD FOR UREA

C        WRITE(12,66) PARM(15),JDAY(I),LZERO

C PUT OUT DISSOLVED ORGANIC N LOADS
        IFLAG=0
        DO J=1,NCELL
          IF (DON(J,I) .GT. 999999) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(16),JDAY(I),(DON(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(16),JDAY(I),(DON(J,I),J=1,NCELL)
        END IF

C PUT OUT DUMMY LOAD FOR REFRACTORY DON

C        WRITE(12,66) PARM(17),JDAY(I),LZERO
	
C PUT OUT PARTICULATE NITROGEN LOADS

        WRITE(12,66) PARM(18),JDAY(I),(LPON(J,I),J=1,NCELL)
        WRITE(12,66) PARM(19),JDAY(I),(RPON(J,I),J=1,NCELL)

C PUT OUT TOTAL PHOSPHATE LOAD

        IFLAG=0
        DO J=1,NCELL
          IF (PO4(J,I) .GT. 999999) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(20),JDAY(I),(PO4(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(20),JDAY(I),(PO4(J,I),J=1,NCELL)
        END IF
	
C PUT OUT DISSOLVED ORGANIC PHOSPHORUS LOADS
        IFLAG=0
        DO J=1,NCELL
          IF (DOP(J,I) .GT. 999999) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(21),JDAY(I),(DOP(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(21),JDAY(I),(DOP(J,I),J=1,NCELL)
        END IF
	
C PUT OUT DUMMY LOAD FOR REFRACTORY DOP

C        WRITE(12,66) PARM(22),JDAY(I),LZERO
	
C PUT OUT THREE PARTICULATE PHOSPHORUS LOADS
	
        IFLAG=0
        DO J=1,NCELL
          IF (LPOP(J,I) .GT. 999999) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(23),JDAY(I),(LPOP(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(23),JDAY(I),(LPOP(J,I),J=1,NCELL)
        END IF

        IFLAG=0
        DO J=1,NCELL
          IF (RPOP(J,I) .GT. 999999) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(24),JDAY(I),(RPOP(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(24),JDAY(I),(RPOP(J,I),J=1,NCELL)
        END IF
	
        IFLAG=0
        DO J=1,NCELL
          IF (PIPOUT(J,I) .GT. 999999) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(25),JDAY(I),(PIPOUT(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(25),JDAY(I),(PIPOUT(J,I),J=1,NCELL)
        END IF

C PUT OUT DUMMY LOADS FOR COD, DO
C WAS DO J=26,29 WHEN SILICA WAS ACTIVE

        DO J=26,27
          WRITE(12,66) PARM(J),JDAY(I),LZERO
        END DO
        
C PUT OUT THREE G3 ORGANIC PARTICLE LOADS

        IFLAG=0
        DO J=1,NCELL
          IF (G3OC(J,I) .GT. 9999999) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,66) PARM(30),JDAY(I),(G3OC(J,I),J=1,NCELL)
        ELSE
          WRITE(12,67) PARM(30),JDAY(I),(G3OC(J,I),J=1,NCELL)
        END IF

        IFLAG=0
        DO J=1,NCELL
          IF (G3ON(J,I) .GT. 999999) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(31),JDAY(I),(G3ON(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(31),JDAY(I),(G3ON(J,I),J=1,NCELL)
        END IF

        IFLAG=0
        DO J=1,NCELL
          IF (G3OP(J,I) .GT. 999999) IFLAG=1
        END DO
        IF (IFLAG .LT. 1) THEN 
          WRITE(12,68) PARM(32),JDAY(I),(G3OP(J,I),J=1,NCELL)
        ELSE
          WRITE(12,66) PARM(32),JDAY(I),(G3OP(J,I),J=1,NCELL)
        END IF

C PUT OUT FOUR SUSPENDED SEDIMENT LOADS

        IFLAG=0
        DO J=1,NCELL
         IF (CLAY(J,I) .GT. 9999999) IFLAG=1
        END DO
        IF (IFLAG .EQ. 0) THEN
          WRITE(12,66) PARM(33),JDAY(I),(CLAY(J,I),J=1,NLOAD(33))
        ELSE
          WRITE(12,67) PARM(33),JDAY(I),(CLAY(J,I),J=1,NLOAD(33))
        END IF

        IFLAG=0
        DO J=1,NCELL
         IF (SILT(J,I) .GT. 9999999) IFLAG=1
        END DO
        IF (IFLAG .EQ. 0) THEN
          WRITE(12,66) PARM(34),JDAY(I),(SILT(J,I),J=1,NLOAD(34))
        ELSE
          WRITE(12,67) PARM(34),JDAY(I),(SILT(J,I),J=1,NLOAD(34))
        END IF

        IFLAG=0
        DO J=1,NCELL
         IF (SAND(J,I) .GT. 9999999) IFLAG=1
        END DO
        IF (IFLAG .EQ. 0) THEN
          WRITE(12,66) PARM(35),JDAY(I),(SAND(J,I),J=1,NLOAD(35))
        ELSE
          WRITE(12,67) PARM(35),JDAY(I),(SAND(J,I),J=1,NLOAD(35))
        END IF

        IFLAG=0
        DO J=1,NCELL
         IF (ORGS(J,I) .GT. 9999999) IFLAG=1
        END DO
        IF (IFLAG .EQ. 0) THEN
          WRITE(12,66) PARM(36),JDAY(I),(ORGS(J,I),J=1,NLOAD(36))
        ELSE
          WRITE(12,67) PARM(36),JDAY(I),(ORGS(J,I),J=1,NLOAD(36))
        END IF

      END DO     

 1    FORMAT(/A72)
 2    FORMAT(/3I8)
 4    FORMAT(/3F8.1/)
 5    FORMAT(A72)
 6    FORMAT(/A72)
 7    FORMAT(/4F8.1/)
 8    FORMAT(/7F8.1/)
 60   FORMAT(/8X,9('   NPSLN'))
 61   FORMAT(8X,9I8)
 62   FORMAT(/4X,A4,9('   NPSLB')/)
 63   FORMAT(/4X,A4,9('   NPSLB'))
 64   FORMAT(:8X,9I8)
 65   FORMAT(/'NPS LOAD','    JDAY',8('  KG/DAY'))
 66   FORMAT(4X,A4,9F8.0:/(:16X,8F8.0))
 67   FORMAT(4X,A4,F8.0,8E8.3:/(:16X,8E8.3))
 68   FORMAT(4X,A4,9F8.1:/(:16X,8F8.1))
 260  FORMAT(I8,2X,F10.0)

C THAT'S ALL FOLKS

      END
          
