      MODULE mod_kinds
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!
        implicit none
        integer, parameter :: i8 = selected_int_kind(8)
        integer, parameter :: c8 = selected_real_kind(6,30)    ! 32-bit
        integer, parameter :: r4 = selected_real_kind(6,30)    ! 32-bit
        integer, parameter :: r8 = selected_real_kind(12,300)  ! 64-bit
        integer, parameter :: r16 = selected_real_kind(15,300) ! 128-bit

      END MODULE mod_kinds



      MODULE mod_param
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!                                                                      !
        USE SIZES
     !  Grid parameters:                                                    !
     !                                                                      !
     !  Nbed       Number of sediment bed layers.                           !
        integer, parameter :: Nbed = LAYMAX

     !  NST        Number of sediment tracer variables
     !             (actually appears to be the number of sediment types)
        integer, parameter :: NST = NSDCLS
      
     !  Set nonlinear, tangent linear, and adjoint models identifiers.
        integer, parameter :: iNLM = 1
      
     !  Set number of ghost-points in the halo region.  It is only used
     !  in distributed-memory applications.
        integer :: NghostPoints = 0 !GHOST_POINTS

        END MODULE mod_param

      

      MODULE mod_scalars
!
!=======================================================================
!  Copyright (c) 2005 ROMS/TOMS Group                                  !
!================================================== Hernan G. Arango ===
!
        USE mod_kinds; USE mod_param
        PUBLIC  :: idsed

        ! make sure that these are correct
        integer, parameter :: Ngrids = 1   ! Number of grids
        
     !  Mean density (Kg/m3) used when the Boussinesq approximation is
     !  inferred.
        real(r8) :: rho0 = 1000.0_r8
        !integer :: idsed(NST)                 ! Cohesive and non-cohesive
        real(r8), dimension(Ngrids) :: dts     ! seconds
        real(r8), dimension(Ngrids) :: time   ! seconds

        CONTAINS

      PURE FUNCTION idsed( j ) RESULT(indx)
!***********************************************************************
!     returns the sediment index
!***********************************************************************
        integer, intent(in) :: j
        integer :: indx

        indx = j
        END FUNCTION

        END MODULE mod_scalars


      MODULE mod_sediment
!
!================================================== John C. Warner   ===
!  Copyright (c) 2005 ROMS/TOMS Group                             !    
!================================================== Hernan G. Arango ===
!                                                                 !    
!  Parameters for sediment model:                                 !    
!                                                                 !    
!   Csed     Sediment concentration (kg/m3), used during analytical    !
!              initialization.                                    !    
!   Erate    Surface erosion rate (kg/m2/s).                      !    
!   Sd50     Median sediment grain diameter (m).                  !    
!   Srho     Sediment grain density (kg/m3).                      !    
!   SedIter  Maximum number of iterations.                        !    
!   Wsed     Particle settling velocity (m/s).                    !    
!   poros    Porosity (non-dimensional: 0.0-1.0):                 !    
!              Vwater/(Vwater+Vsed).                              !    
!   tau_ce   Kinematic critical shear for erosion (m2/s2).        !    
!   tau_cd   Kinematic critical shear for deposition (m2/s2).     !    
!                                                                 !    
!  BED properties indices:                                        !    
!                                                                 !    
!   MBEDP    Number of bed properties (array dimension).          !    
!   idBmas   Sedimen mass index.                                  !    
!   idSbed   IO indices for bed properties variables.             !    
!   idfrac   sediment class fraction (non-dimensional).           !    
!   ithck    Sediment layer thickness (m).                        !    
!   iaged    Sediment layer age (s).                              !    
!   iporo    Sediment layer porosity (non-dimensional).           !    
!   idiff    Sediment layer bio-diffusivity (m2/s).               !    
!                                                                 !    
!  BOTTOM properties indices:                                     !    
!                                                                 !    
!   MBOTP    Number of bottom properties (array dimension).       !    
!   idBott   IO indices for bottom properties variables.          !    
!   isd50    Median sediment grain diameter (m).                  !    
!   idens    Median sediment grain density (kg/m3).               !    
!   iwsed    Mean settling velocity (m/s).                        !    
!   itauc    Mean critical erosion stress (m2/s2).                !    
!   irlen    Sediment ripple length (m).                          !    
!   irhgt    Sediment ripple height (m).                          !    
!   ibwav    Bed wave excursion amplitude (m).                    !    
!   izdef    Default bottom roughness (m).                        !    
!   izapp    Apparent bottom roughness (m).                       !    
!   izNik    Nikuradse bottom roughness (m).                      !    
!   izbio    Biological bottom roughness (m).                     !    
!   izbfm    Bed form bottom roughness (m).                       !    
!   izbld    Bed load bottom roughness (m).                       !    
!   izwbl    Bottom roughness used wave BBL (m).                  !     
!   iactv    Active layer thickness for erosive potential (m).    !    
!   ishgt    Sediment saltation height (m).                       !    
!   idoff    Offset for calculation of dmix erodibility profile (m)    !
!   idslp    Slope for calculation of dmix or erodibility profile !    
!   idtim    Time scale for restoring erodibility profile (s)     !    
!                                                                 !    
!=======================================================================
!
        USE mod_param; USE mod_kinds; USE mod_scalars
        implicit none
        integer, parameter :: MBEDP = 4    ! Bed Properties:
        integer, parameter :: ithck = 1    ! layer thickness
        integer, parameter :: iaged = 2    ! layer age
        integer, parameter :: iporo = 3    ! layer porosity
        integer, parameter :: idiff = 4    ! layer bio-diffusivity
        integer, parameter :: MBOTP = 19   ! Bottom Properties:
        integer, parameter :: isd50 = 1    ! mean grain diameter
        integer, parameter :: idens = 2    ! mean grain density
        integer, parameter :: iwsed = 3    ! mean settle velocity
        integer, parameter :: itauc = 4    ! critical erosion stress
        integer, parameter :: irlen = 5    ! ripple length
        integer, parameter :: irhgt = 6    ! ripple height
        integer, parameter :: ibwav = 7    ! wave excursion amplitude
        integer, parameter :: izdef = 8    ! default bottom roughness
        integer, parameter :: izapp = 9    ! apparent bottom roughness
        integer, parameter :: izNik = 10   ! Nikuradse bottom roughness
        integer, parameter :: izbio = 11   ! biological bottom roughness
        integer, parameter :: izbfm = 12   ! bed form bottom roughness
        integer, parameter :: izbld = 13   ! bed load bottom roughness
        integer, parameter :: izwbl = 14   ! wave bottom roughness
        integer, parameter :: iactv = 15   ! active layer thickness
        integer, parameter :: ishgt = 16   ! saltation height
        integer, parameter :: idoff = 17   ! dmix offset
        integer, parameter :: idslp = 18   ! dmix slope
        integer, parameter :: idtim = 19   ! erodibility time scale
        real(r8) :: Erate(NST,Ngrids) !     erosion rate
        real(r8) :: Sd50(NST,Ngrids)  !     mediam grain diameter
        real(r8) :: Srho(NST,Ngrids)  !     grain density
        real(r8) :: Wsed(NST,nsbp)    !     settling velocity  ! CFC 07/24/08
   !    real(r8) :: poros(NST,Ngrids) !     porosity
        real(r8) :: tau_ce(NST,Ngrids)!     shear for erosion
	real(r8) :: Gamma0            !     Parameter in sand equilibrium concentration
   !    real(r8) :: tau_cd(NST,Ngrids)!     shear for deposition
        real(r8) :: morph_fac(NST,Ngrids)  ! morphological scale factor
        real(r8) :: newlayer_thick(Ngrids) ! new layer deposit thickness criteria
      END MODULE mod_sediment
