************************************************************************
** This code replaces the algal routine in the St Johns River model.  **
** Droop kinetics removed.  Updates including salinity toxicity       **
** installed.  This code originated as                                **
** /disk2/oysters/source_code/ches_bay_50000/PARWQM_ALGAE.f           **
** Elements incorporated from St. Johns code                          **
** /disk2/new_ches_bay/terrys_code_FGS/wqm_alg.F                      **
**                                                                    **
**                  Algal  Subroutines for CE-QUAL-ICM                **
**                                                                    **
**                            Version 2.0                             **
**                         January 27, 2006                           **
**                                                                    **
**                    Water Quality Modeling Group                    **
**                    U.S. Army Corps of Engineers                    **
**                    Waterways Experiment Station                    **
**                    Vicksburg, Mississippi 39180                    **
**                                                                    **
************************************************************************

      MODULE ALGAL
      USE WQM; USE FILE_INFO
      IMPLICIT NONE
C
      CHARACTER(72),SAVE :: ALG_TITLE(6)
      CHARACTER(8),SAVE  :: SPVAR1, SPVAR2, SPVAR3
      CHARACTER(8),SAVE  :: PRINT1, PRINT2, PRINT3
      CHARACTER(8),SAVE  :: TPVAR,  TPRINT, TB2GR,  PRINTB2
      REAL,SAVE  ::  KTG11, KTG12, KTB1, KTG21, KTG22, KTB2, KTG31 
      REAL,SAVE  ::  KTG32, KTB3,  KTPR
      REAL,SAVE  ::  NETP1, NETP2, NETP3, IK
      REAL,SAVE  ::  XL(NSBP), STOX1(NBP), STOX2(NBP), STOX3(NBP)
      REAL,SAVE  ::  TRPR, TMP1, TR1, TMP2, TR2, TMP3, TR3, TLOOK
      REAL,SAVE  ::  SALTOX, DIN, PO4AVL, ALPHA, DF
      REAL,SAVE  ::  FI01, FI02, FI03, GPP1, GPP2, GPP3, TREC
C
      CONTAINS

************************************************************************
**             S U B R O U T I N E   A L G _ R E A D                  **
************************************************************************

      SUBROUTINE ALG_READ
      IMPLICIT NONE
      INTEGER      ::  I, J, F, B

C TITLE CARDS

      READ(AGR,1010) (ALG_TITLE(J),J=1,6)

C READ PARAMETERS WHICH ARE IDENTICAL FOR ALL GROUPS

      READ (AGR,1030)  TRPR,  KTPR
      READ (AGR,1030)  FNIP,  FNLDP, FNRDP, FNLPP, FNRPP, FNG3P
      READ (AGR,1030)  FPIP,  FPLDP, FPRDP, FPLPP, FPRPP, FPG3P
      READ (AGR,1030)  FDOP,  FCLDP, FCRDP, FCLPP, FCRPP, FCG3P

C READ SPATIALLY-INVARIANT PARAMETERS FOR ALGAL GROUP 1

      READ(AGR,1030) ANC1, APC1, STF1
      READ(AGR,1030) CCHLC1
      READ(AGR,1030) KHN1,KHNH41,KHP1,KHR1,KHST1
      READ(AGR,1030) ALPH1,PRSP1,PRPWR1
      READ(AGR,1030) TMP1,TR1
      READ(AGR,1030) KTG11,KTG12,KTB1
      READ(AGR,1030) FNI1,FNLD1,FNRD1,FNLP1,FNRP1,FNG31
      READ(AGR,1030) FPI1,FPLD1,FPRD1,FPLP1,FPRP1,FPG31
      READ(AGR,1030) FCLD1,FCRD1,FCLP1,FCRP1,FCG31

C READ SPATIALLY-INVARIANT PARAMETERS FOR ALGAL GROUP 2

      READ(AGR,1030) ANC2, APC2, STF2
      READ(AGR,1030) CCHLC2
      READ(AGR,1030) KHN2,KHNH42,KHP2,KHR2,KHST2
      READ(AGR,1030) ALPH2,PRSP2,PRPWR2
      READ(AGR,1030) TMP2,TR2
      READ(AGR,1030) KTG21,KTG22,KTB2
      READ(AGR,1030) FNI2,FNLD2,FNRD2,FNLP2,FNRP2,FNG32
      READ(AGR,1030) FPI2,FPLD2,FPRD2,FPLP2,FPRP2,FPG32
      READ(AGR,1030) FCLD2,FCRD2,FCLP2,FCRP2,FCG32

C READ SPATIALLY-INVARIANT PARAMETERS FOR ALGAL GROUP 3

      READ(AGR,1030) ANC3, APC3, STF3
      READ(AGR,1030) CCHLC3
      READ(AGR,1030) KHN3,KHNH43,KHP3,KHR3,KHST3
      READ(AGR,1030) ALPH3,PRSP3,PRPWR3
      READ(AGR,1030) TMP3,TR3
      READ(AGR,1030) KTG31,KTG32,KTB3
      READ(AGR,1030) FNI3,FNLD3,FNRD3,FNLP3,FNRP3,FNG33
      READ(AGR,1030) FPI3,FPLD3,FPRD3,FPLP3,FPRP3,FPG33
      READ(AGR,1030) FCLD3,FCRD3,FCLP3,FCRP3,FCG33

C CREATE LOOKUP TABLE FOR TEMPERATURE EFFECTS

      DO I = -50,400
        TLOOK = REAL(I)/10.
        IF (TLOOK.LT.TMP1) THEN
            FT1(I) = EXP(-KTG11*(TLOOK-TMP1)**2)
          ELSE
            FT1(I) = EXP(-KTG12*(TMP1-TLOOK)**2)
        END IF
        FTBM1(I)=EXP(KTB1*(TLOOK-TR1))
        IF (TLOOK.LT.TMP2) THEN
            FT2(I) = EXP(-KTG21*(TLOOK-TMP2)**2)
          ELSE
            FT2(I) = EXP(-KTG22*(TMP2-TLOOK)**2)
        END IF
        FTBM2(I)=EXP(KTB2*(TLOOK-TR2))
        IF (TLOOK.LT.TMP3) THEN
            FT3(I) = EXP(-KTG31*(TLOOK-TMP3)**2)
          ELSE
            FT3(I) = EXP(-KTG32*(TMP3-TLOOK)**2)
        END IF
        FTBM3(I)=EXP(KTB3*(TLOOK-TR3))
        FTPR(I)=EXP(KTPR*(TLOOK-TRPR))
      END DO
      
C ASSIGN CARBON-TO-CHLOROPHYLL RATIOS TO ALL CELLS

      DO B=1,NB
        CCHL1(B) = CCHLC1
	CCHL2(B) = CCHLC2
	CCHL3(B) = CCHLC3
      END DO
      
      KHPAVG = (KHP1+KHP2+KHP3)/3.

C ARE REMAINING GROUP 1 PARAMETERS SPATIALLY VARYING?

      READ(AGR,1040) SPVAR1, PRINT1
      READ(AGR,1030) PM1(1), BMR1(1), BPR1(1)
      IF (SPVAR1 .EQ. 'CONSTANT') THEN
        DO B=2,NB
          PM1(B) = PM1(1)
          BMR1(B) = BMR1(1)
          BPR1(B) = BPR1(1)
        END DO
      ELSE
        DO B=2,NB
          READ(AGR,1032) PM1(B), BMR1(B), BPR1(B)
        END DO
      END IF      

C ARE REMAINING GROUP 2 PARAMETERS SPATIALLY VARYING?

      READ(AGR,1040) SPVAR2, PRINT2
      READ(AGR,1030) PM2(1), BMR2(1), BPR2(1)
      IF (SPVAR2 .EQ. 'CONSTANT') THEN
        DO B=2,NB
          PM2(B) = PM2(1)
          BMR2(B) = BMR2(1)
          BPR2(B) = BPR2(1)
        END DO
      ELSE
        DO B=2,NB
          READ(AGR,1032) PM2(B), BMR2(B), BPR2(B)
        END DO
      END IF      

C ARE REMAINING GROUP 3 PARAMETERS SPATIALLY VARYING?

      READ(AGR,1040) SPVAR3, PRINT3
      READ(AGR,1030) PM3(1), BMR3(1), BPR3(1)
      IF (SPVAR3 .EQ. 'CONSTANT') THEN
        DO B=2,NB
          PM3(B) = PM3(1)
          BMR3(B) = BMR3(1)
          BPR3(B) = BPR3(1)
        END DO
      ELSE
        DO B=2,NB
          READ(AGR,1032) PM3(B), BMR3(B), BPR3(B)
        END DO
      END IF      

C TIME DEPENDENCE OF GROWTH BY SPRING ALGAL GROUP

      READ(AGR,1040) TB2GR, PRINTB2
      IF (TB2GR .EQ. 'CONSTANT') THEN
        READ(AGR,1060) B2GR(1)
        DO J=2,366
          B2GR(J) = B2GR(1)
        END DO
      ELSE
        READ(AGR,1060) (B2GR(J), J=1,366)
      END IF 

***** Input FORMAT statements

 1010 FORMAT(A72)
 1030 FORMAT(//(8X,9F8.0))
 1032 FORMAT(8X,9F8.0)
 1040 FORMAT(//8X,8A8)
 1060 FORMAT(//(16X,F8.0))

C OUTPUT WHAT WAS INPUT

      OPEN(ALO,FILE=ALOFN)
      WRITE(ALO,2002) (ALG_TITLE(J),J=1,6)

C WRITE ALGAL PROPERTIES WHICH ARE NOT SPATIALLY VARYING

      WRITE(ALO,3000)
      WRITE(ALO,3016) CCHLC1, CCHLC2, CCHLC3
      WRITE(ALO,3020) ANC1, ANC2, ANC3
      WRITE(ALO,3022) APC1, APC2, APC3
      WRITE(ALO,3072) STF1, STF2, STF3
      WRITE(ALO,3040) KHN1, KHN2, KHN3
      WRITE(ALO,3042) KHNH41, KHNH42, KHNH43
      WRITE(ALO,3050) KHP1, KHP2, KHP3
      WRITE(ALO,3070) KHR1, KHR2, KHR3
      WRITE(ALO,3074) KHST1,KHST2,KHST3
      WRITE(ALO,3080) ALPH1, ALPH2, ALPH3
      WRITE(ALO,4000) PRSP1, PRSP2, PRSP3
      WRITE(ALO,4002) PRPWR1, PRPWR2, PRPWR3
      WRITE(ALO,4010) TMP1, TMP2, TMP3
      WRITE(ALO,5020) TR1, TR2, TR3
      WRITE(ALO,5030) KTG11, KTG21, KTG31
      WRITE(ALO,5040) KTG12, KTG22, KTG32
      WRITE(ALO,5050) KTB1, KTB2, KTB3

C WRITE DISTRIBUTION OF BIOMASS UPON MORTALITY

      WRITE(ALO,4020)
      WRITE(ALO,4030) FNI1,FNLD1,FNRD1,FNLP1,FNRP1,FNG31
      WRITE(ALO,4040) FPI1,FPLD1,FPRD1,FPLP1,FPRP1,FPG31
      WRITE(ALO,4050) FCLD1,FCRD1,FCLP1,FCRP1,FCG31
      WRITE(ALO,4060)
      WRITE(ALO,4030) FNI2,FNLD2,FNRD2,FNLP2,FNRP2,FNG32
      WRITE(ALO,4040) FPI2,FPLD2,FPRD2,FPLP2,FPRP2,FPG32
      WRITE(ALO,4050) FCLD2,FCRD2,FCLP2,FCRP2,FCG32
      WRITE(ALO,4070)
      WRITE(ALO,4030) FNI3,FNLD3,FNRD3,FNLP3,FNRP3,FNG33
      WRITE(ALO,4040) FPI3,FPLD3,FPRD3,FPLP3,FPRP3,FPG33
      WRITE(ALO,4050) FCLD3,FCRD3,FCLP3,FCRP3,FCG33
      WRITE(ALO,4090)
      WRITE(ALO,4030) FNIP,FNLDP,FNRDP,FNLPP,FNRPP,FNG3P
      WRITE(ALO,4040) FPIP,FPLDP,FPRDP,FPLPP,FPRPP,FPG3P
      WRITE(ALO,4080) FDOP,FCLDP,FCRDP,FCLPP,FCRPP,FCG3P
 
C WRITE SPATIALLY-VARYING PARAMETERS FOR GROUP 1

      WRITE(ALO,2000)
      IF (SPVAR1 . EQ. 'CONSTANT') THEN
        WRITE(ALO,2085)
      ELSE
        WRITE(ALO,2086)
      END IF
      WRITE(ALO,5060)
      IF (PRINT1 .NE. '     ALL') THEN
        WRITE(ALO,5070) PM1(1), BMR1(1), BPR1(1)
      ELSE
        WRITE(ALO,5080) (B, PM1(B), BMR1(B), BPR1(B), B=1,NB)
      END IF
      
C WRITE SPATIALLY-VARYING PARAMETERS FOR GROUP 2

      WRITE(ALO,2005)
      IF (SPVAR2 . EQ. 'CONSTANT') THEN
        WRITE(ALO,2085)
      ELSE
        WRITE(ALO,2086)
      END IF
      WRITE(ALO,5060)
      IF (PRINT2 .NE. '     ALL') THEN
        WRITE(ALO,5070) PM2(1), BMR2(1), BPR2(1)
      ELSE
        WRITE(ALO,5080) (B, PM2(B), BMR2(B), BPR2(B), B=1,NB)
      END IF

C WRITE SPATIALLY-VARYING PARAMETERS FOR GROUP 3

      WRITE(ALO,2006)
      IF (SPVAR3 . EQ. 'CONSTANT') THEN
        WRITE(ALO,2085)
      ELSE
        WRITE(ALO,2086)
      END IF
      WRITE(ALO,5060)
      IF (PRINT3 .NE. '     ALL') THEN
        WRITE(ALO,5070) PM3(1), BMR3(1), BPR3(1)
      ELSE
        WRITE(ALO,5080) (B, PM3(B), BMR3(B), BPR3(B), B=1,NB)
      END IF

C WRITE TERMS FOR PREDATION BY HIGHER TROPHIC LEVELS

      WRITE(ALO,2040) TRPR, KTPR
      
C WRITE TIME DEPENDENCE OF GROWTH OF SPRING ALGAL GROUP

      IF (TB2GR .EQ. 'CONSTANT') THEN
        WRITE(ALO,2094)
      ELSE
        WRITE(ALO,2095)
      END IF 
      WRITE(ALO,2093)
      IF (PRINTB2 .NE. '     ALL') THEN
        WRITE(ALO,2090) (J, B2GR(J), J=1,1)
      ELSE
        WRITE(ALO,2090) (J, B2GR(J), J=1,366)
      END IF
      
      
***** Output FORMAT statements

 2000 FORMAT(/' ALGAL GROUP 1')
 2002 FORMAT(1X,A72)
 2005 FORMAT(/' ALGAL GROUP 2')
 2006 FORMAT(/' ALGAL GROUP 3')
 2040 FORMAT(' PREDATION SPECIFIED AT ',F8.2,' C.'/
     $  ' TEMPERATURE EFFECT = ',F8.3,' PER DEGREE')
 2085 FORMAT(/' REMAINING PARAMETERS ARE SPATIALLY-INVARIANT')
 2086 FORMAT(/' REMAINING PARAMETERS ARE SPATIALLY-VARYING')
 2090 FORMAT(I8,F8.3)
 2093 FORMAT(/'    DAY     B2GR')
 2094 FORMAT(/' BASE GROUP 2 GROWTH IS TEMPORALLY-INVARIANT')
 2095 FORMAT(/' BASE GROUP 2 VARIES TEMPORALLY')
 3000 FORMAT(/' ALGAL PROPERTIES',30X,
     $         'GROUP 1   GROUP 2   GROUP 3')
 3016 FORMAT(' C:CHL RATIO (GM/GM)    ',20X,3F10.4)
 3020 FORMAT(' GM N/GM C              ',20X,3F10.4)
 3022 FORMAT(' GM P/GM C              ',20X,3F10.4)
 3040 FORMAT(' KHN (GM N/M**3)        ',20X,3F10.4)
 3042 FORMAT(' KHNH4 (GM N/M**3)      ',20X,3F10.4)
 3050 FORMAT(' KHP (GM P/M**3)        ',20X,3F10.4)
 3070 FORMAT(' KHR (GM DO/M**3)       ',20X,3F10.4)
 3072 FORMAT(' SALT TOXICITY (1/DAY)  ',20X,3F10.4)
 3074 FORMAT(' KHST (ppt)             ',20X,3F10.4)
 3080 FORMAT(' ALPHA (GM C/GM CHL/DAY)/(uE/M**2/SEC)      ',3F10.3)
 4000 FORMAT(' PHOTORESPIRATION FRACTION     ',13X,3F10.3)
 4002 FORMAT(' PREDATION RAISED TO POWER     ',13X,3F10.3)
 4010 FORMAT(' OPTIMAL TEMPERATURE FOR PRODUCTION (C)',5X,3F10.3) 
 4020 FORMAT(/' DISTRIBUTION OF ALGAE UPON MORTALITY'//
     $  ' GROUP 1 RESPIRATION  DIS INORG  LAB DISS  REF DISS  LAB PART  
     $ REF PART   G3 PART')
 4030 FORMAT(' NITROGEN            ',6F10.3)
 4040 FORMAT(' PHOSPHORUS          ',6F10.3)
 4050 FORMAT(' CARBON              ',10X,5F10.3)
 4060 FORMAT(/' GROUP 2 RESPIRATION')
 4070 FORMAT(/' GROUP 3 RESPIRATION')
 4080 FORMAT(' CARBON              ',6F10.3)
 4090 FORMAT(/' PREDATION')
 5000 FORMAT(' PHOSPHORUS     ',4F10.3)
 5010 FORMAT(' CARBON         ',4F10.3)
 5020 FORMAT(' REFERENCE TEMPERATURE FOR RESPIRATION (C)  ',3F10.3)
 5030 FORMAT(' EFFECT OF SUBOPTIMAL TEMP ON PRODUCTION    ',3F10.4) 
 5040 FORMAT(' EFFECT OF SUPEROPTIMAL TEMP ON PRODUCTION  ',3F10.4) 
 5050 FORMAT(' EFFECT OF TEMPERATURE ON RESPIRATION       ',3F10.4)
 5060 FORMAT('       CELL     PMAX     METAB     PRDTN',/
     $       '             C/CHL/DAY   1/DAY  GM/M**3/DAY'/)
 5070 FORMAT(10X,3F10.3)
 5080 FORMAT(I10,3F10.3)

      RETURN
      END SUBROUTINE ALG_READ
      



************************************************************************
**                  S U B R O U T I N E   A L G A E                   **
************************************************************************

        SUBROUTINE ALGAE
        IMPLICIT NONE
        INTEGER  ::  J, F, B, ITEMP

C DETERMINE JULIAN DAY

        J = 1.0 + AMOD(JDAY,365.25)

C SALINITY TOXICITY

        DO B=1,NB
         SALTOX = MAX(0., SALT(B))
         STOX1(B)=STF1*0.5*(1.+TANH(SALTOX-KHST1))
         STOX2(B)=STF2*(1.-0.5*(1.+TANH(SALTOX-KHST2)))
         STOX3(B)=STF3*0.5*(1.+TANH(SALTOX-KHST3))
        END DO

C TEMPERATURE EFFECTS ON PRODUCTION AND RESPIRATION

        DO 10070 B=1,NB

          ITEMP = 10.*T(B)+0.05
          P1(B) = PM1(B)*FT1(ITEMP)
          P2(B) = PM2(B)*FT2(ITEMP)*B2GR(J)
          P3(B) = PM3(B)*FT3(ITEMP)
          BM1(B) = BMR1(B)*FTBM1(ITEMP)+STOX1(B)
          BM2(B) = BMR2(B)*FTBM2(ITEMP)+STOX2(B)
          BM3(B) = BMR3(B)*FTBM3(ITEMP)+STOX3(B)
          PR1(B) = BPR1(B)*FTPR(ITEMP)*B1(B)**PRPWR1
          PR2(B) = BPR2(B)*FTPR(ITEMP)*B2(B)**PRPWR2
          PR3(B) = BPR3(B)*FTPR(ITEMP)*B3(B)**PRPWR3

10070   CONTINUE

C NUTRIENT LIMITATIONS - NITROGEN

        DO 10050 B=1,NB

          DIN = NH4(B)+NO3(B)
          NL1(B) = DIN/(KHN1+DIN)
          NL2(B) = DIN/(KHN2+DIN)
          NL3(B) = DIN/(KHN3+DIN)

10050   CONTINUE

C PHOSPHORUS

        DO 10060 B=1,NB

C         *** Phosphorus available for algal growth

          IF (SEDKIN .EQ. 'SSI') THEN
            DF = 1./(1.+KADPO4*SSI(B))
	  ELSE
	    DF = 1./(1.+KADPO4*SEDCLY(B))
	  END IF
          PO4AVL = MAX(0.,DF*PO4(B))
          PL1(B) = PO4AVL/(KHP1+PO4AVL)
          PL2(B) = PO4AVL/(KHP2+PO4AVL)
          PL3(B) = PO4AVL/(KHP3+PO4AVL)                  

10060   CONTINUE

C PHOTOSYNTHESIS VS IRRADIANCE

        DO 10040 B=1,NB

          ALPHA = ALPH1
          IK = P1(B)*AMIN1(NL1(B),PL1(B))/(ALPHA+1.0E-10)
          FI1(B) = IAVG(B)/SQRT(IK*IK+IAVG(B)*IAVG(B)+1.0E-10)

          ALPHA = ALPH2
          IK = P2(B)*AMIN1(NL2(B),PL2(B))/(ALPHA+1.0E-10)
          FI2(B) = IAVG(B)/SQRT(IK*IK+IAVG(B)*IAVG(B)+1.0E-10)

          ALPHA = ALPH3
          IK = P3(B)*AMIN1(NL3(B),PL3(B))/(ALPHA+1.0E-10)
          FI3(B) = IAVG(B)/SQRT(IK*IK+IAVG(B)*IAVG(B)+1.0E-10)

10040   CONTINUE

C COMPUTE ASSIMILATION RATIO AT WATER SURFACE (GM C/GM CHL/DAY)
C AND CARBON FIXATION (GM C/M**3/DAY)

        DO B=1,NSB

          ALPHA = ALPH1
          IK = P1(B)*AMIN1(NL1(B),PL1(B))/(ALPHA+1.0E-6)
          FI01 = I0/SQRT(IK*IK+I0*I0+1.0E-10)

          ALPHA = ALPH2
          IK = P2(B)*AMIN1(NL2(B),PL2(B))/(ALPHA+1.0E-6)
          FI02 = I0/SQRT(IK*IK+I0*I0+1.0E-10)

          ALPHA = ALPH3
          IK = P3(B)*AMIN1(NL3(B),PL3(B))/(ALPHA+1.0E-6)
          FI03 = I0/SQRT(IK*IK+I0*I0+1.0E-10)

          NETP1 = P1(B)*FI01*AMIN1(NL1(B),PL1(B))*(1.-PRSP1)
     $      -BM1(B)*CCHL1(B)
          NETP2 = P2(B)*FI02*AMIN1(NL2(B),PL2(B))*(1.-PRSP2)
     $      -BM2(B)*CCHL2(B)
          NETP3 = P3(B)*FI03*AMIN1(NL3(B),PL3(B))*(1.-PRSP3)
     $      -BM3(B)*CCHL3(B)

          NASRAT(B) = (NETP1*B1(B)+NETP2*B2(B)+NETP3*B3(B))
     $             / (B1(B)+B2(B)+B3(B)+1.0E-6)

          ASRAT(B) = (P1(B)*AMIN1(NL1(B),PL1(B))*B1(B)
     $             + P2(B)*AMIN1(NL2(B),PL2(B))*B2(B)
     $             + P3(B)*AMIN1(NL3(B),PL3(B))*B3(B))
     $             / (B1(B)+B2(B)+B3(B)+1.0e-6)

          NETP1 = (P1(B)*AMIN1(NL1(B),PL1(B))*(1.-PRSP1)
     $      /CCHL1(B)-BM1(B))*B1(B)
          NETP2 = (P2(B)*AMIN1(NL2(B),PL2(B))*(1.-PRSP2)
     $      /CCHL2(B)-BM2(B))*B2(B)
          NETP3 = (P3(B)*AMIN1(NL3(B),PL3(B))*(1.-PRSP3)
     $      /CCHL3(B)-BM3(B))*B3(B)
          CFIX(B) = NETP1+NETP2+NETP3

        END DO

C EFFECTS OF LIGHT AND NUTRIENTS ON PRODUCTION
C CONVERT FROM GM C/GM CHL/DAY TO SPECIFIC GROWTH RATE

          DO B=1,NB
            P1(B) = P1(B)*FI1(B)*AMIN1(NL1(B),PL1(B))/CCHL1(B)
            P2(B) = P2(B)*FI2(B)*AMIN1(NL2(B),PL2(B))/CCHL2(B)
            P3(B) = P3(B)*FI3(B)*AMIN1(NL3(B),PL3(B))/CCHL3(B)
          END DO

C RATE OF CHANGE DUE TO PRODUCTION, RESPIRATION, PREDATION

        DO B=1,NB
        
          NETP1 = (P1(B)*(1.-PRSP1)-BM1(B))*B1(B)
          NETP2 = (P2(B)*(1.-PRSP2)-BM2(B))*B2(B)
          NETP3 = (P3(B)*(1.-PRSP3)-BM3(B))*B3(B)
          GPP1 = P1(B)*B1(B)
          GPP2 = P2(B)*B2(B)
          GPP3 = P3(B)*B3(B)

C PRIMARY PRODUCTION IN GM C/M**2/DAY

          GPP(B) = (GPP1+GPP2+GPP3)*BL(B,3)
          NPP(B) = (NETP1+NETP2+NETP3)*BL(B,3)

          DTB1(B) = (NETP1-PR1(B))/86400.
          DTB2(B) = (NETP2-PR2(B))/86400.
          DTB3(B) = (NETP3-PR3(B))/86400.

        END DO

C RATE OF CHANGE DUE TO SETTLING
          
        DO B=1,NB

          DTB1(B) = DTB1(B)+(WS1(BU(B))*B1(BU(B))
     $              -WS1(B)*B1(B))/BL(B,3)/86400.
          DTB2(B) = DTB2(B)+(WS2(BU(B))*B2(BU(B))
     $              -WS2(B)*B2(B))/BL(B,3)/86400.
          DTB3(B) = DTB3(B)+(WS3(BU(B))*B3(BU(B))
     $              -WS3(B)*B3(B))/BL(B,3)/86400.

        END DO

C SETTLING FLUX FOR MASS BALANCE

      IF (S_TRANS_FLUX) THEN
        DO F=NHQF+1,NQF
	  B = JB(F)
          FLXS1(F) = -WS1(B)*B1(B)*V2(B)/(BL(B,3)*86400.)
          FLXS2(F) = -WS2(B)*B2(B)*V2(B)/(BL(B,3)*86400.)
          FLXS3(F) = -WS3(B)*B3(B)*V2(B)/(BL(B,3)*86400.)
        END DO
      END IF
        
C  RESUSPENSION

        IF (SEDIMENT_CALC) THEN 
            
          TREC=1.0/86400.
          DO B=1,NBB 
            XL(B)=TREC/BL(BBN(B),3)
          END DO

          DO 10111 B=1,NBB 
            DTB1(BBN(B)) = DTB1(BBN(B))+(WS1(BBN(B))-WS1NET(B))*
     &                     B1(BBN(B))*XL(B)
10111     CONTINUE
          DO 10112 B=1,NBB 
            DTB2(BBN(B)) = DTB2(BBN(B))+(WS2(BBN(B))-WS2NET(B))*
     &                     B2(BBN(B))*XL(B)
10112     CONTINUE
          DO 10113 B=1,NBB 
            DTB3(BBN(B)) = DTB3(BBN(B))+(WS3(BBN(B))-WS3NET(B))*
     &                     B3(BBN(B))*XL(B)
10113    CONTINUE
        END IF 

      RETURN
      END SUBROUTINE ALGAE

      END MODULE ALGAL


