      subroutine read_wetlands ()
        use wetlands_parms
        use FILE_INFO; use WQM_INIT
        implicit none

        character(len=1) :: inline
        integer :: i, b

! open wetlands input file
      open(wtl_unit,file=wetlands_input,status='old')

! read two title lines
      read(wtl_unit,*) inline
      read(wtl_unit,*) inline

! read setling rates
      read(wtl_unit,*) inline
      read(wtl_unit,*) wtl_wss, wtl_wsl, wtl_wsr, wtl_wsg3, wtl_wsb1, &
        wtl_wsb2, wtl_wsb3, wtl_wspip, wtl_wsclay, wtl_wssilt, &
        wtl_wssand, wtl_wsfclay

! read parameters for wetlands respiration
      read(wtl_unit,*) inline
      read(wtl_unit,*) wtl_resp, wtl_resp_kt, wtl_resp_tr, &
        wtl_resp_khdo
! prevent division by zero
      wtl_resp_khdo = max(wtl_resp_khdo,1.0e-6)

! read nitrate exchange coefficient
      read(wtl_unit,*) inline
      read(wtl_unit,*) wtl_no3_exch

! read number of wetland cells
      read(wtl_unit,*) inline
      read(wtl_unit,*) nwtlcell

! read wqm grid cell, adjacent wetlands area
      read(wtl_unit,*) inline
      do i=1,nwtlcell
        read(wtl_unit,*) b, wtl_area(b)
        wtl_cell(i) = b
      end do

      close(wtl_unit)   

! write grid cell and wetlands area to output file
      open(wtl_write,file=wetlands_opt,status='unknown',  &
        form='unformatted')
      write(wtl_write) nwtlcell
      do i=1,nwtlcell
        write(wtl_write) i, wtl_cell(i), wtl_area(wtl_cell(i))
      end do

      return
      end

      subroutine calc_wetlands ()
        use wetlands_parms
        use WQM
        implicit none

        integer :: i, ibox
        real :: pfrac, ppo4, mindo

! calculate settling of particles in wetland
! I think the WQM wants rate of change to WQM cells in g/m3/s
! m/d * m2 * g/m3 * d/86400s / m3 = g/m3/s

      do i=1,nwtlcell
        ibox=wtl_cell(i)

        dtssi(ibox) = dtssi(ibox) - &
          wtl_wss * wtl_area(ibox) * ssi(ibox) / v1(ibox) / 86400.

        dtb1(ibox) = dtb1(ibox) - &
          wtl_wsb1 * wtl_area(ibox) * b1(ibox) / v1(ibox) / 86400.
        dtb2(ibox) = dtb2(ibox) - &
          wtl_wsb2 * wtl_area(ibox) * b2(ibox) / v1(ibox) / 86400.
        dtb3(ibox) = dtb3(ibox) - &
          wtl_wsb3 * wtl_area(ibox) * b3(ibox) / v1(ibox) / 86400.

        dtlpoc(ibox) = dtlpoc(ibox) - &
          wtl_wsl * wtl_area(ibox) * lpoc(ibox) / v1(ibox) / 86400.
        dtrpoc(ibox) = dtrpoc(ibox) - &
          wtl_wsr * wtl_area(ibox) * rpoc(ibox) / v1(ibox) / 86400.
        dtg3poc(ibox) = dtg3poc(ibox) - &
          wtl_wsg3 * wtl_area(ibox) * g3poc(ibox) / v1(ibox) / 86400.

        dtlpon(ibox) = dtlpon(ibox) - &
          wtl_wsl * wtl_area(ibox) * lpon(ibox) / v1(ibox) / 86400.
        dtrpon(ibox) = dtrpon(ibox) - &
          wtl_wsr * wtl_area(ibox) * rpon(ibox) / v1(ibox) / 86400.
        dtg3pon(ibox) = dtg3pon(ibox) - &
          wtl_wsg3 * wtl_area(ibox) * g3pon(ibox) / v1(ibox) / 86400.

        dtlpop(ibox) = dtlpop(ibox) - &
          wtl_wsl * wtl_area(ibox) * lpop(ibox) / v1(ibox) / 86400.
        dtrpop(ibox) = dtrpop(ibox) - &
          wtl_wsr * wtl_area(ibox) * rpop(ibox) / v1(ibox) / 86400.
        dtg3pop(ibox) = dtg3pop(ibox) - &
          wtl_wsg3 * wtl_area(ibox) * g3pop(ibox) / v1(ibox) / 86400.
        dtpip(ibox) = dtpip(ibox) - &
          wtl_wspip * wtl_area(ibox) * pip(ibox) / v1(ibox) / 86400.

        pfrac = kadpo4 * ssi(ibox)/(1.0+kadpo4*ssi(ibox))
        ppo4 = pfrac * po4(ibox)
        dtpo4(ibox) = dtpo4(ibox) - &
          wtl_wss * wtl_area(ibox) * ppo4 / v1(ibox) / 86400.

        dtscly(ibox) = dtscly(ibox) - &
          wtl_wsclay * wtl_area(ibox) * sedcly(ibox) / v1(ibox) / 86400.
        dtsslt(ibox) = dtsslt(ibox) - &
          wtl_wssilt * wtl_area(ibox) * sedslt(ibox) / v1(ibox) / 86400.
        dtssnd(ibox) = dtssnd(ibox) - &
          wtl_wssand * wtl_area(ibox) * sedsnd(ibox) / v1(ibox) / 86400.
        dtsorg(ibox) = dtsorg(ibox) - &
          wtl_wsfclay * wtl_area(ibox) * sedorg(ibox) / v1(ibox) / 86400.

      end do

! change in DO and COD due to wetlands respiration
! I think the WQM wants rate of change to WQM cells in g/m3/s
! g/m2/d * m2 * d/86400s / m3 = g/m3/s

      do i=1,nwtlcell
        ibox=wtl_cell(i)

        mindo = max(do(ibox),0.0) ! eliminate negative values
        dtdo(ibox) = dtdo(ibox) - wtl_resp * &
          exp(wtl_resp_kt*(t(ibox)-wtl_resp_tr)) * &
          mindo/(wtl_resp_khdo+mindo) * wtl_area(ibox) / &
          v1(ibox) / 86400.
        dtcod(ibox) = dtcod(ibox) + wtl_resp * &
          exp(wtl_resp_kt*(t(ibox)-wtl_resp_tr)) * &
          wtl_resp_khdo/(wtl_resp_khdo+mindo) * wtl_area(ibox) / &
          v1(ibox) / 86400.

      end do

! denitrification via direct nitrate uptake

      do i=1,nwtlcell
        ibox=wtl_cell(i)

        dtno3(ibox) = dtno3(ibox) - wtl_no3_exch * &
          exp(wtl_resp_kt*(t(ibox)-wtl_resp_tr)) * &
          no3(ibox) * wtl_area(ibox) / v1(ibox) / 86400.

      end do


! accumulate rates

      do i=1,nwtlcell
        ibox=wtl_cell(i)

        wtl_dlta_ssi(ibox) = wtl_dlta_ssi(ibox) - &
          wtl_wss * wtl_area(ibox) * ssi(ibox) * dlt  ! g/d * s

        wtl_dlta_b1(ibox) = wtl_dlta_b1(ibox) - &
          wtl_wsb1 * wtl_area(ibox) * b1(ibox) * dlt  ! g/d * s
        wtl_dlta_b2(ibox) = wtl_dlta_b2(ibox) - &
          wtl_wsb2 * wtl_area(ibox) * b2(ibox) * dlt  ! g/d * s
        wtl_dlta_b3(ibox) = wtl_dlta_b3(ibox) - &
          wtl_wsb3 * wtl_area(ibox) * b3(ibox) * dlt  ! g/d * s

! Algal N and P.  For now, combine it with the labile N and P pools

        wtl_dlta_lpon(ibox) = wtl_dlta_lpon(ibox) - &
          anc1 * wtl_wsb1 * wtl_area(ibox) * b1(ibox) * dlt - &
          anc2 * wtl_wsb2 * wtl_area(ibox) * b2(ibox) * dlt - &
          anc3 * wtl_wsb3 * wtl_area(ibox) * b3(ibox) * dlt  ! g/d * s
        wtl_dlta_lpop(ibox) = wtl_dlta_lpop(ibox) - &
          apc1 * wtl_wsb1 * wtl_area(ibox) * b1(ibox) * dlt - &
          apc2 * wtl_wsb2 * wtl_area(ibox) * b2(ibox) * dlt - &
          apc3 * wtl_wsb3 * wtl_area(ibox) * b3(ibox) * dlt  ! g/d * s

        wtl_dlta_lpoc(ibox) = wtl_dlta_lpoc(ibox) - &
          wtl_wsl * wtl_area(ibox) * lpoc(ibox) * dlt  ! g/d * s
        wtl_dlta_rpoc(ibox) = wtl_dlta_rpoc(ibox) - &
          wtl_wsr * wtl_area(ibox) * rpoc(ibox) * dlt  ! g/d * s
        wtl_dlta_g3poc(ibox) = wtl_dlta_g3poc(ibox) - &
          wtl_wsg3 * wtl_area(ibox) * g3poc(ibox) * dlt  ! g/d * s

        wtl_dlta_lpon(ibox) = wtl_dlta_lpon(ibox) - &
          wtl_wsl * wtl_area(ibox) * lpon(ibox) * dlt  ! g/d * s
        wtl_dlta_rpon(ibox) = wtl_dlta_rpon(ibox) - &
          wtl_wsr * wtl_area(ibox) * rpon(ibox) * dlt  ! g/d * s
        wtl_dlta_g3pon(ibox) = wtl_dlta_g3pon(ibox) - &
          wtl_wsg3 * wtl_area(ibox) * g3pon(ibox) * dlt  ! g/d * s

        wtl_dlta_lpop(ibox) = wtl_dlta_lpop(ibox) - &
          wtl_wsl * wtl_area(ibox) * lpop(ibox) * dlt  ! g/d * s
        wtl_dlta_rpop(ibox) = wtl_dlta_rpop(ibox) - &
          wtl_wsr * wtl_area(ibox) * rpop(ibox) * dlt  ! g/d * s
        wtl_dlta_g3pop(ibox) = wtl_dlta_g3pop(ibox) - &
          wtl_wsg3 * wtl_area(ibox) * g3pop(ibox) * dlt  ! g/d * s
        wtl_dlta_pip(ibox) = wtl_dlta_pip(ibox) - &
          wtl_wss * wtl_area(ibox) * pip(ibox) * dlt  ! g/d * s

        pfrac = kadpo4 * ssi(ibox)/(1.0+kadpo4*ssi(ibox))
        ppo4 = pfrac * po4(ibox)
        wtl_dlta_po4(ibox) = wtl_dlta_po4(ibox) - &
          wtl_wss * wtl_area(ibox) * ppo4 * dlt  ! g/d * s

        wtl_dlta_clay(ibox) = wtl_dlta_clay(ibox) - &
          wtl_wsclay * wtl_area(ibox) * sedcly(ibox) * dlt  ! g/d * s
        wtl_dlta_silt(ibox) = wtl_dlta_silt(ibox) - &
          wtl_wssilt * wtl_area(ibox) * sedslt(ibox) * dlt  ! g/d * s
        wtl_dlta_sand(ibox) = wtl_dlta_sand(ibox) - &
          wtl_wssand * wtl_area(ibox) * sedsnd(ibox) * dlt  ! g/d * s
        wtl_dlta_fclay(ibox) = wtl_dlta_fclay(ibox) - &
          wtl_wsfclay * wtl_area(ibox) * sedorg(ibox) * dlt  ! g/d * s

        mindo = max(do(ibox),0.0) ! eliminate negative values
        wtl_dlta_do(ibox) = wtl_dlta_do(ibox) - wtl_resp * &
          exp(wtl_resp_kt*(t(ibox)-wtl_resp_tr)) * &
          mindo/(wtl_resp_khdo+mindo) * wtl_area(ibox) * dlt   ! g/d * s
        wtl_dlta_cod(ibox) = wtl_dlta_cod(ibox) + wtl_resp * &
          exp(wtl_resp_kt*(t(ibox)-wtl_resp_tr)) * &
          wtl_resp_khdo/(wtl_resp_khdo+mindo) * wtl_area(ibox) * dlt ! g/d * s

        wtl_dlta_no3(ibox) = wtl_dlta_no3(ibox) - wtl_no3_exch * &
          exp(wtl_resp_kt*(t(ibox)-wtl_resp_tr)) * &
          no3(ibox) * wtl_area(ibox) * dlt   ! g/d * s

      end do
      
      wtl_avgint = wtl_avgint + dlt

      return
      end

      subroutine write_wetlands ()
        use wetlands_parms
        use WQM; use FILE_INFO; use WQM_INIT
        implicit none

        integer :: i, ibox

! for ascii output, change "e)" to "e,*)"
      write(wtl_write) jday

! take average, convert dlta from g to kg in write statement

      write(wtl_write) (wtl_dlta_ssi(i)/wtl_avgint/1000.,i=1,nsb)

      write(wtl_write) (wtl_dlta_b1(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_b2(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_b3(i)/wtl_avgint/1000.,i=1,nsb)

      write(wtl_write) (wtl_dlta_lpoc(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_rpoc(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_g3poc(i)/wtl_avgint/1000.,i=1,nsb)

      write(wtl_write) (wtl_dlta_no3(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_lpon(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_rpon(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_g3pon(i)/wtl_avgint/1000.,i=1,nsb)

      write(wtl_write) (wtl_dlta_lpop(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_rpop(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_g3pop(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_pip(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_po4(i)/wtl_avgint/1000.,i=1,nsb)

      write(wtl_write) (wtl_dlta_do(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_cod(i)/wtl_avgint/1000.,i=1,nsb)

      write(wtl_write) (wtl_dlta_clay(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_silt(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_sand(i)/wtl_avgint/1000.,i=1,nsb)
      write(wtl_write) (wtl_dlta_fclay(i)/wtl_avgint/1000.,i=1,nsb)

! reset averaging interval and accumulators
      wtl_avgint = 0.0

      wtl_dlta_ssi = 0.0

      wtl_dlta_b1 = 0.0
      wtl_dlta_b2 = 0.0      
      wtl_dlta_b3 = 0.0

      wtl_dlta_lpoc = 0.0
      wtl_dlta_rpoc = 0.0
      wtl_dlta_g3poc = 0.0

      wtl_dlta_no3 = 0.0
      wtl_dlta_lpon = 0.0
      wtl_dlta_rpon = 0.0
      wtl_dlta_g3pon = 0.0

      wtl_dlta_lpop = 0.0
      wtl_dlta_rpop = 0.0
      wtl_dlta_g3pop = 0.0
      wtl_dlta_pip = 0.0
      wtl_dlta_po4 = 0.0

      wtl_dlta_do = 0.0
      wtl_dlta_cod = 0.0

      wtl_dlta_clay = 0.0
      wtl_dlta_silt = 0.0
      wtl_dlta_sand = 0.0
      wtl_dlta_fclay = 0.0

      return
      end
